/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.PropertyLookup;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.util.Providers;

public class PropertyReader
implements PropertyLookup {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;

    public PropertyReader(PropertyStore propertyStore, NodeStore nodeStore) {
        this.propertyStore = propertyStore;
        this.nodeStore = nodeStore;
    }

    public List<PropertyBlock> propertyBlocks(NodeRecord nodeRecord) {
        Collection records = this.propertyStore.getPropertyRecordChain(nodeRecord.getNextProp());
        ArrayList<PropertyBlock> propertyBlocks = new ArrayList<PropertyBlock>();
        for (PropertyRecord record : records) {
            propertyBlocks.addAll(record.getPropertyBlocks());
        }
        return propertyBlocks;
    }

    public DefinedProperty propertyValue(PropertyBlock block) {
        return block.getType().readProperty(block.getKeyIndexId(), block, Providers.singletonProvider((Object)this.propertyStore));
    }

    public Property nodeProperty(long nodeId, int propertyKeyId) {
        try {
            NodeRecord nodeRecord = this.nodeStore.getRecord(nodeId);
            for (PropertyBlock block : this.propertyBlocks(nodeRecord)) {
                if (block.getKeyIndexId() != propertyKeyId) continue;
                return this.propertyValue(block);
            }
        }
        catch (InvalidRecordException e) {
            // empty catch block
        }
        return Property.noNodeProperty((long)nodeId, (int)propertyKeyId);
    }
}

