/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.incremental;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.AbstractStoreProcessor;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;

class StoreProcessor
extends AbstractStoreProcessor {
    private final ConsistencyReport.Reporter report;

    StoreProcessor(ConsistencyReport.Reporter report) {
        this.report = report;
    }

    @Override
    protected void checkNode(RecordStore<NodeRecord> store, NodeRecord node, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.report.forNodeChange((NodeRecord)store.forceGetRaw((AbstractBaseRecord)node), node, checker);
    }

    @Override
    protected void checkRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        this.report.forRelationshipChange((RelationshipRecord)store.forceGetRaw((AbstractBaseRecord)rel), rel, checker);
    }

    @Override
    protected void checkProperty(RecordStore<PropertyRecord> store, PropertyRecord property, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.report.forPropertyChange((PropertyRecord)store.forceGetRaw((AbstractBaseRecord)property), property, checker);
    }

    @Override
    protected void checkRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> store, RelationshipTypeTokenRecord record, RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
        this.report.forRelationshipTypeNameChange((RelationshipTypeTokenRecord)store.forceGetRaw((AbstractBaseRecord)record), record, checker);
    }

    @Override
    protected void checkLabelToken(RecordStore<LabelTokenRecord> store, LabelTokenRecord record, RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
        this.report.forLabelNameChange((LabelTokenRecord)store.forceGetRaw((AbstractBaseRecord)record), record, checker);
    }

    @Override
    protected void checkPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> store, PropertyKeyTokenRecord record, RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
        this.report.forPropertyKeyChange((PropertyKeyTokenRecord)store.forceGetRaw((AbstractBaseRecord)record), record, checker);
    }

    @Override
    protected void checkDynamic(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord string, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.report.forDynamicBlockChange(type, (DynamicRecord)store.forceGetRaw((AbstractBaseRecord)string), string, checker);
    }

    @Override
    protected void checkDynamicLabel(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord string, RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> checker) {
        this.report.forDynamicLabelBlockChange(type, (DynamicRecord)store.forceGetRaw((AbstractBaseRecord)string), string, checker);
    }

    @Override
    protected void checkRelationshipGroup(RecordStore<RelationshipGroupRecord> store, RelationshipGroupRecord record, RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> checker) {
        this.report.forRelationshipGroupChange((RelationshipGroupRecord)store.forceGetRaw((AbstractBaseRecord)record), record, checker);
    }
}

