/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Arrays;
import org.neo4j.consistency.checking.ChainCheck;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;

public abstract class PrimitiveRecordCheck<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
implements RecordCheck<RECORD, REPORT> {
    private final RecordField<RECORD, REPORT>[] fields;
    public final ComparativeRecordChecker<RECORD, PrimitiveRecord, REPORT> ownerCheck = new ComparativeRecordChecker<RECORD, PrimitiveRecord, REPORT>(){

        @Override
        public void checkReference(RECORD record, PrimitiveRecord other, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            if (record.getId() == other.getId() && record.getClass() == other.getClass()) {
                return;
            }
            if (other instanceof NodeRecord) {
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).multipleOwners((NodeRecord)other);
            } else if (other instanceof RelationshipRecord) {
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).multipleOwners((RelationshipRecord)other);
            } else if (other instanceof NeoStoreRecord) {
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).multipleOwners((NeoStoreRecord)other);
            }
        }
    };

    @SafeVarargs
    PrimitiveRecordCheck(RecordField<RECORD, REPORT> ... fields) {
        this.fields = Arrays.copyOf(fields, fields.length + 1);
        this.fields[fields.length] = new FirstProperty();
    }

    @Override
    public void check(RECORD record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        if (!record.inUse()) {
            return;
        }
        for (RecordField<RECORD, REPORT> field : this.fields) {
            field.checkConsistency(record, engine, records);
        }
    }

    @Override
    public void checkChange(RECORD oldRecord, RECORD newRecord, CheckerEngine<RECORD, REPORT> engine, DiffRecordAccess records) {
        this.check(newRecord, engine, (RecordAccess)records);
        if (oldRecord.inUse()) {
            for (RecordField<RECORD, REPORT> field : this.fields) {
                field.checkChange(oldRecord, newRecord, engine, records);
            }
        }
    }

    private class FirstProperty
    implements RecordField<RECORD, REPORT>,
    ComparativeRecordChecker<RECORD, PropertyRecord, REPORT> {
        private FirstProperty() {
        }

        @Override
        public void checkConsistency(RECORD record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            if (!Record.NO_NEXT_PROPERTY.is(record.getNextProp())) {
                engine.comparativeCheck(records.property(record.getNextProp()), this);
            }
        }

        @Override
        public long valueFrom(RECORD record) {
            return record.getNextProp();
        }

        @Override
        public void checkChange(RECORD oldRecord, RECORD newRecord, CheckerEngine<RECORD, REPORT> engine, DiffRecordAccess records) {
            if (!(newRecord.inUse() && this.valueFrom(oldRecord) == this.valueFrom(newRecord) || Record.NO_NEXT_PROPERTY.is(this.valueFrom(oldRecord)) || records.changedProperty(this.valueFrom(oldRecord)) != null)) {
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotUpdated();
            }
        }

        @Override
        public void checkReference(RECORD record, PropertyRecord property, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            if (!property.inUse()) {
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotInUse(property);
            } else {
                if (!Record.NO_PREVIOUS_PROPERTY.is(property.getPrevProp())) {
                    ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotFirstInChain(property);
                }
                new ChainCheck().checkReference(record, property, engine, records);
            }
        }
    }
}

