/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import java.io.IOException;
import java.util.Iterator;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.index.IndexAccessor;

public class IndexIterator
implements BoundedIterable<Long> {
    private final IndexAccessor indexAccessor;
    private BoundedIterable<Long> indexReader;

    public IndexIterator(IndexAccessor indexAccessor) {
        this.indexAccessor = indexAccessor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long maxCount() {
        try (BoundedIterable reader = this.indexAccessor.newAllEntriesReader();){
            long l = reader.maxCount();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
        }
    }

    public Iterator<Long> iterator() {
        if (this.indexReader == null) {
            this.indexReader = this.indexAccessor.newAllEntriesReader();
        }
        return this.indexReader.iterator();
    }
}

