/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;

public enum DynamicStore {
    SCHEMA(RecordType.SCHEMA){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.schema(block);
        }

        @Override
        DynamicRecord changed(DiffRecordAccess records, long id) {
            return records.changedSchema(id);
        }
    }
    ,
    STRING(RecordType.STRING_PROPERTY){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.string(block);
        }

        @Override
        DynamicRecord changed(DiffRecordAccess records, long id) {
            return records.changedString(id);
        }
    }
    ,
    ARRAY(RecordType.ARRAY_PROPERTY){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.array(block);
        }

        @Override
        DynamicRecord changed(DiffRecordAccess records, long id) {
            return records.changedArray(id);
        }
    }
    ,
    PROPERTY_KEY(RecordType.PROPERTY_KEY_NAME){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.propertyKeyName((int)block);
        }

        @Override
        DynamicRecord changed(DiffRecordAccess records, long id) {
            return null;
        }
    }
    ,
    RELATIONSHIP_TYPE(RecordType.RELATIONSHIP_TYPE_NAME){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.relationshipTypeName((int)block);
        }

        @Override
        DynamicRecord changed(DiffRecordAccess records, long id) {
            return null;
        }
    }
    ,
    LABEL(RecordType.LABEL_NAME){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.labelName((int)block);
        }

        @Override
        DynamicRecord changed(DiffRecordAccess records, long id) {
            return null;
        }
    }
    ,
    NODE_LABEL(RecordType.NODE_DYNAMIC_LABEL){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.nodeLabels(block);
        }

        @Override
        DynamicRecord changed(DiffRecordAccess records, long id) {
            return null;
        }
    };

    public final RecordType type;

    private DynamicStore(RecordType type) {
        this.type = type;
    }

    abstract RecordReference<DynamicRecord> lookup(RecordAccess var1, long var2);

    abstract DynamicRecord changed(DiffRecordAccess var1, long var2);
}

