/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.incremental;

import org.neo4j.consistency.checking.InconsistentStoreException;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DiffStore;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class DiffCheck {
    final StringLogger logger;

    public DiffCheck(StringLogger logger) {
        this.logger = logger;
    }

    public final void check(DiffStore diffs) throws InconsistentStoreException, ConsistencyCheckIncompleteException {
        this.verify(diffs, this.execute(diffs));
    }

    public abstract ConsistencySummaryStatistics execute(DiffStore var1) throws ConsistencyCheckIncompleteException;

    protected void verify(DiffStore diffs, ConsistencySummaryStatistics summary) throws InconsistentStoreException {
        if (!summary.isConsistent()) {
            throw new InconsistentStoreException(summary);
        }
    }
}

