/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.NodeCorrectlyIndexedCheck;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;

public class NodeToLabelIndexesProcessor
implements RecordProcessor<NodeRecord> {
    private final ConsistencyReporter reporter;
    private final RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> nodeIndexCheck;

    public NodeToLabelIndexesProcessor(ConsistencyReporter reporter, IndexAccessors indexes, PropertyReader propertyReader) {
        this.reporter = reporter;
        this.nodeIndexCheck = new NodeCorrectlyIndexedCheck(indexes, propertyReader);
    }

    @Override
    public void process(NodeRecord nodeRecord) {
        this.reporter.forNode(nodeRecord, this.nodeIndexCheck);
    }

    @Override
    public void close() {
    }
}

