/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.windowpool.WindowPoolImplementation;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.index.lucene.LuceneLabelScanStoreBuilder;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.StringLogger;

public class ConsistencyCheckService {
    private final Date timestamp;

    public ConsistencyCheckService() {
        this(new Date());
    }

    public ConsistencyCheckService(Date timestamp) {
        this.timestamp = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(String storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, StringLogger logger) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        Map params = tuningConfiguration.getParams();
        params.put(GraphDatabaseSettings.store_dir.name(), storeDir);
        tuningConfiguration.applyChanges(params);
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        StoreFactory factory = new StoreFactory(tuningConfiguration, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), ((WindowPoolImplementation)((Object)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_window_pool_implementation))).windowPoolFactory(tuningConfiguration, logger), (FileSystemAbstraction)fileSystem, logger, (RemoteTxHook)new DefaultTxHook());
        File reportFile = this.chooseReportPath(tuningConfiguration);
        StringLogger report = StringLogger.lazyLogger((File)reportFile);
        NeoStore neoStore = factory.newNeoStore(new File(storeDir, "neostore"));
        try {
            neoStore.makeStoreOk();
            StoreAccess store = new StoreAccess(neoStore);
            LabelScanStore labelScanStore = null;
            try {
                labelScanStore = new LuceneLabelScanStoreBuilder(storeDir, store.getRawNeoStore(), (FileSystemAbstraction)fileSystem, logger).build();
                LuceneSchemaIndexProvider indexes = new LuceneSchemaIndexProvider(DirectoryFactory.PERSISTENT, tuningConfiguration);
                DirectStoreAccess stores = new DirectStoreAccess(store, labelScanStore, (SchemaIndexProvider)indexes);
                summary = new FullCheck(tuningConfiguration, progressFactory).execute(stores, StringLogger.tee((StringLogger)logger, (StringLogger)report));
            }
            finally {
                try {
                    if (null != labelScanStore) {
                        labelScanStore.shutdown();
                    }
                }
                catch (IOException e) {
                    logger.error("Faiure during shutdown of label scan store", (Throwable)e);
                }
            }
        }
        finally {
            report.close();
            neoStore.close();
        }
        if (!summary.isConsistent()) {
            logger.logMessage(String.format("See '%s' for a detailed consistency report.", reportFile.getPath()));
            return Result.FAILURE;
        }
        return Result.SUCCESS;
    }

    private File chooseReportPath(Config tuningConfiguration) {
        File reportPath = (File)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_report_file);
        if (reportPath == null) {
            return new File((File)tuningConfiguration.get(GraphDatabaseSettings.store_dir), ConsistencyCheckService.defaultLogFileName(this.timestamp));
        }
        if (reportPath.isDirectory()) {
            return new File(reportPath, ConsistencyCheckService.defaultLogFileName(this.timestamp));
        }
        return reportPath;
    }

    public static String defaultLogFileName(Date date) {
        String formattedDate = new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date);
        return String.format("inconsistencies-%s.report", formattedDate);
    }

    public static enum Result {
        FAILURE(false),
        SUCCESS(true);

        private boolean successful;

        private Result(boolean successful) {
            this.successful = successful;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

