/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store.windowpool;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.neo4j.consistency.store.windowpool.MappedWindow;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;

public class FileMapper {
    private final StoreChannel fileChannel;

    public FileMapper(StoreChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public long fileSizeInBytes() throws IOException {
        return this.fileChannel.size();
    }

    public MappedWindow mapWindow(long firstRecord, int recordsPerPage, int bytesPerRecord) throws IOException {
        return new MappedWindow(recordsPerPage, bytesPerRecord, firstRecord, this.fileChannel.map(FileChannel.MapMode.READ_ONLY, firstRecord * (long)bytesPerRecord, (long)(recordsPerPage * bytesPerRecord)));
    }
}

