/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.store.DelegatingRecordAccess;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;

public class FilteringRecordAccess
extends DelegatingRecordAccess {
    private final Set<MultiPassStore> potentiallySkippableStores = new HashSet<MultiPassStore>();
    private final int iPass;
    private final long recordsPerPass;
    private final MultiPassStore currentStore;

    public FilteringRecordAccess(DiffRecordAccess delegate, int iPass, long recordsPerPass, MultiPassStore currentStore, MultiPassStore ... potentiallySkippableStores) {
        super(delegate);
        this.iPass = iPass;
        this.recordsPerPass = recordsPerPass;
        this.currentStore = currentStore;
        this.potentiallySkippableStores.addAll(Arrays.asList(potentiallySkippableStores));
    }

    @Override
    public RecordReference<NodeRecord> node(long id) {
        if (this.shouldSkip(id, MultiPassStore.NODES)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.node(id);
    }

    @Override
    public RecordReference<RelationshipRecord> relationship(long id) {
        if (this.shouldSkip(id, MultiPassStore.RELATIONSHIPS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.relationship(id);
    }

    @Override
    public RecordReference<PropertyRecord> property(long id) {
        if (this.shouldSkip(id, MultiPassStore.PROPERTIES)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.property(id);
    }

    @Override
    public RecordReference<DynamicRecord> string(long id) {
        if (this.shouldSkip(id, MultiPassStore.STRINGS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.string(id);
    }

    @Override
    public RecordReference<DynamicRecord> array(long id) {
        if (this.shouldSkip(id, MultiPassStore.ARRAYS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.array(id);
    }

    private boolean shouldSkip(long id, MultiPassStore store) {
        return this.potentiallySkippableStores.contains((Object)store) && (!this.isCurrentStore(store) || !MultiPassStore.recordInCurrentPass(id, this.iPass, this.recordsPerPass));
    }

    private boolean isCurrentStore(MultiPassStore store) {
        return this.currentStore == store;
    }

    static enum Mode {
        SKIP,
        FILTER;

    }
}

