/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.AbstractStoreProcessor;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.SchemaRecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;

class StoreProcessor
extends AbstractStoreProcessor {
    private final ConsistencyReport.Reporter report;
    private SchemaRecordCheck schemaRecordCheck;

    public StoreProcessor(CheckDecorator decorator, ConsistencyReport.Reporter report) {
        super(decorator);
        this.report = report;
        this.schemaRecordCheck = null;
    }

    protected void checkSchema(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord schema, RecordCheck<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> checker) {
        this.report.forSchema(schema, checker);
    }

    @Override
    protected void checkNode(RecordStore<NodeRecord> store, NodeRecord node, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.report.forNode(node, checker);
    }

    @Override
    protected void checkRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        this.report.forRelationship(rel, checker);
    }

    @Override
    protected void checkProperty(RecordStore<PropertyRecord> store, PropertyRecord property, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.report.forProperty(property, checker);
    }

    @Override
    protected void checkRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> store, RelationshipTypeTokenRecord relationshipType, RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
        this.report.forRelationshipTypeName(relationshipType, checker);
    }

    @Override
    protected void checkLabelToken(RecordStore<LabelTokenRecord> store, LabelTokenRecord label, RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
        this.report.forLabelName(label, checker);
    }

    @Override
    protected void checkPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> store, PropertyKeyTokenRecord key, RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
        this.report.forPropertyKey(key, checker);
    }

    @Override
    protected void checkDynamic(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord string, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.report.forDynamicBlock(type, string, checker);
    }

    @Override
    protected void checkDynamicLabel(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord string, RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> checker) {
        this.report.forDynamicLabelBlock(type, string, checker);
    }

    @Override
    protected void checkRelationshipGroup(RecordStore<RelationshipGroupRecord> store, RelationshipGroupRecord record, RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> checker) {
        this.report.forRelationshipGroup(record, checker);
    }

    void setSchemaRecordCheck(SchemaRecordCheck schemaRecordCheck) {
        this.schemaRecordCheck = schemaRecordCheck;
    }

    @Override
    public void processSchema(RecordStore<DynamicRecord> store, DynamicRecord schema) {
        if (null == this.schemaRecordCheck) {
            super.processSchema(store, schema);
        } else {
            this.checkSchema(RecordType.SCHEMA, store, schema, this.schemaRecordCheck);
        }
    }
}

