/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;

public class RelationshipGroupRecordCheck
implements RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> {
    private static final List<RecordField<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport>> fields;

    @Override
    public void check(RelationshipGroupRecord record, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, RecordAccess records) {
        if (!record.inUse()) {
            return;
        }
        for (RecordField<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> field : fields) {
            field.checkConsistency(record, engine, records);
        }
    }

    @Override
    public void checkChange(RelationshipGroupRecord oldRecord, RelationshipGroupRecord newRecord, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, DiffRecordAccess records) {
        this.check(newRecord, engine, (RecordAccess)records);
        if (oldRecord.inUse()) {
            for (RecordField<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> field : fields) {
                field.checkChange(oldRecord, newRecord, engine, records);
            }
        }
    }

    static {
        ArrayList<Enum> list = new ArrayList<Enum>();
        list.add(RelationshipTypeField.RELATIONSHIP_TYPE);
        list.add(GroupField.NEXT);
        list.add(NodeField.OWNER);
        list.addAll(Arrays.asList(RelationshipField.values()));
        fields = Collections.unmodifiableList(list);
    }

    private static enum RelationshipField implements RecordField<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport>,
    ComparativeRecordChecker<RelationshipGroupRecord, RelationshipRecord, ConsistencyReport.RelationshipGroupConsistencyReport>
    {
        OUT{

            @Override
            public long valueFrom(RelationshipGroupRecord record) {
                return record.getFirstOut();
            }

            @Override
            protected void relationshipNotInUse(ConsistencyReport.RelationshipGroupConsistencyReport report) {
                report.firstOutgoingRelationshipNotInUse();
            }

            @Override
            protected void relationshipNotFirstInChain(ConsistencyReport.RelationshipGroupConsistencyReport report) {
                report.firstOutgoingRelationshipNotFirstInChain();
            }

            @Override
            protected boolean isFirstInChain(RelationshipRecord relationship) {
                return relationship.isFirstInFirstChain();
            }

            @Override
            protected void relationshipOfOtherType(ConsistencyReport.RelationshipGroupConsistencyReport report) {
                report.firstOutgoingRelationshipOfOfOtherType();
            }
        }
        ,
        IN{

            @Override
            public long valueFrom(RelationshipGroupRecord record) {
                return record.getFirstIn();
            }

            @Override
            protected void relationshipNotInUse(ConsistencyReport.RelationshipGroupConsistencyReport report) {
                report.firstIncomingRelationshipNotInUse();
            }

            @Override
            protected void relationshipNotFirstInChain(ConsistencyReport.RelationshipGroupConsistencyReport report) {
                report.firstIncomingRelationshipNotFirstInChain();
            }

            @Override
            protected boolean isFirstInChain(RelationshipRecord relationship) {
                return relationship.isFirstInSecondChain();
            }

            @Override
            protected void relationshipOfOtherType(ConsistencyReport.RelationshipGroupConsistencyReport report) {
                report.firstIncomingRelationshipOfOfOtherType();
            }
        }
        ,
        LOOP{

            @Override
            public long valueFrom(RelationshipGroupRecord record) {
                return record.getFirstLoop();
            }

            @Override
            protected void relationshipNotInUse(ConsistencyReport.RelationshipGroupConsistencyReport report) {
                report.firstLoopRelationshipNotInUse();
            }

            @Override
            protected void relationshipNotFirstInChain(ConsistencyReport.RelationshipGroupConsistencyReport report) {
                report.firstLoopRelationshipNotFirstInChain();
            }

            @Override
            protected boolean isFirstInChain(RelationshipRecord relationship) {
                return relationship.isFirstInSecondChain() && relationship.isFirstInSecondChain();
            }

            @Override
            protected void relationshipOfOtherType(ConsistencyReport.RelationshipGroupConsistencyReport report) {
                report.firstLoopRelationshipOfOfOtherType();
            }
        };


        @Override
        public void checkConsistency(RelationshipGroupRecord record, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, RecordAccess records) {
            long relId = this.valueFrom(record);
            if (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                engine.comparativeCheck(records.relationship(relId), this);
            }
        }

        @Override
        public void checkChange(RelationshipGroupRecord oldRecord, RelationshipGroupRecord newRecord, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, DiffRecordAccess records) {
        }

        @Override
        public void checkReference(RelationshipGroupRecord record, RelationshipRecord referred, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, RecordAccess records) {
            if (!referred.inUse()) {
                this.relationshipNotInUse(engine.report());
            } else {
                if (!this.isFirstInChain(referred)) {
                    this.relationshipNotFirstInChain(engine.report());
                }
                if (referred.getType() != record.getType()) {
                    this.relationshipOfOtherType(engine.report());
                }
            }
        }

        protected abstract void relationshipOfOtherType(ConsistencyReport.RelationshipGroupConsistencyReport var1);

        protected abstract void relationshipNotFirstInChain(ConsistencyReport.RelationshipGroupConsistencyReport var1);

        protected abstract boolean isFirstInChain(RelationshipRecord var1);

        protected abstract void relationshipNotInUse(ConsistencyReport.RelationshipGroupConsistencyReport var1);
    }

    private static enum GroupField implements RecordField<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport>,
    ComparativeRecordChecker<RelationshipGroupRecord, RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport>
    {
        NEXT;


        @Override
        public void checkConsistency(RelationshipGroupRecord record, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, RecordAccess records) {
            if (record.getNext() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                engine.comparativeCheck(records.relationshipGroup(record.getNext()), this);
            }
        }

        @Override
        public long valueFrom(RelationshipGroupRecord record) {
            return record.getNext();
        }

        @Override
        public void checkChange(RelationshipGroupRecord oldRecord, RelationshipGroupRecord newRecord, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, DiffRecordAccess records) {
        }

        @Override
        public void checkReference(RelationshipGroupRecord record, RelationshipGroupRecord referred, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, RecordAccess records) {
            if (!referred.inUse()) {
                engine.report().nextGroupNotInUse();
            } else {
                if (record.getType() >= referred.getType()) {
                    engine.report().invalidTypeSortOrder();
                }
                if (record.getOwningNode() != referred.getOwningNode()) {
                    engine.report().nextHasOtherOwner(referred);
                }
            }
        }
    }

    private static enum RelationshipTypeField implements RecordField<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport>,
    ComparativeRecordChecker<RelationshipGroupRecord, RelationshipTypeTokenRecord, ConsistencyReport.RelationshipGroupConsistencyReport>
    {
        RELATIONSHIP_TYPE;


        @Override
        public void checkConsistency(RelationshipGroupRecord record, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, RecordAccess records) {
            if (record.getType() < 0) {
                engine.report().illegalRelationshipType();
            } else {
                engine.comparativeCheck(records.relationshipType(record.getType()), this);
            }
        }

        @Override
        public long valueFrom(RelationshipGroupRecord record) {
            return record.getType();
        }

        @Override
        public void checkChange(RelationshipGroupRecord oldRecord, RelationshipGroupRecord newRecord, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, DiffRecordAccess records) {
        }

        @Override
        public void checkReference(RelationshipGroupRecord record, RelationshipTypeTokenRecord referred, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, RecordAccess records) {
            if (!referred.inUse()) {
                engine.report().relationshipTypeNotInUse(referred);
            }
        }
    }

    private static enum NodeField implements RecordField<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport>,
    ComparativeRecordChecker<RelationshipGroupRecord, NodeRecord, ConsistencyReport.RelationshipGroupConsistencyReport>
    {
        OWNER;


        @Override
        public void checkReference(RelationshipGroupRecord record, NodeRecord referred, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, RecordAccess records) {
            if (!referred.inUse()) {
                engine.report().ownerNotInUse();
            }
        }

        @Override
        public void checkConsistency(RelationshipGroupRecord record, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, RecordAccess records) {
            if (record.getOwningNode() < 0L) {
                engine.report().illegalOwner();
            } else {
                engine.comparativeCheck(records.node(record.getOwningNode()), this);
            }
        }

        @Override
        public long valueFrom(RelationshipGroupRecord record) {
            return record.getOwningNode();
        }

        @Override
        public void checkChange(RelationshipGroupRecord oldRecord, RelationshipGroupRecord newRecord, CheckerEngine<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> engine, DiffRecordAccess records) {
        }
    }
}

