/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLogFiles;
import org.neo4j.kernel.impl.util.StringLogger;

public class ConsistencyCheckTool {
    private static final String RECOVERY = "recovery";
    private static final String CONFIG = "config";
    private final ConsistencyCheckService consistencyCheckService;
    private final PrintStream systemError;

    public static void main(String[] args) {
        ConsistencyCheckTool tool = new ConsistencyCheckTool(new ConsistencyCheckService(), System.err);
        try {
            tool.run(args);
        }
        catch (ToolFailureException e) {
            e.haltJVM();
        }
    }

    ConsistencyCheckTool(ConsistencyCheckService consistencyCheckService, PrintStream systemError) {
        this.consistencyCheckService = consistencyCheckService;
        this.systemError = systemError;
    }

    void run(String ... args) throws ToolFailureException {
        Args arguments = new Args(args);
        String storeDir = this.determineStoreDirectory(arguments);
        Config tuningConfiguration = this.readTuningConfiguration(storeDir, arguments);
        this.attemptRecoveryOrCheckStateOfLogicalLogs(arguments, storeDir);
        StringLogger logger = StringLogger.SYSTEM;
        try {
            this.consistencyCheckService.runFullConsistencyCheck(storeDir, tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)System.err), logger);
        }
        catch (ConsistencyCheckIncompleteException e) {
            throw new ToolFailureException("Check aborted due to exception", e);
        }
        finally {
            logger.flush();
        }
    }

    private void attemptRecoveryOrCheckStateOfLogicalLogs(Args arguments, String storeDir) {
        if (arguments.getBoolean(RECOVERY, Boolean.valueOf(false), Boolean.valueOf(true)).booleanValue()) {
            new GraphDatabaseFactory().newEmbeddedDatabase(storeDir).shutdown();
        } else {
            XaLogicalLogFiles logFiles = new XaLogicalLogFiles(new File(storeDir, "nioneo_logical.log"), (FileSystemAbstraction)new DefaultFileSystemAbstraction());
            try {
                switch (logFiles.determineState()) {
                    case LEGACY_WITHOUT_LOG_ROTATION: {
                        this.systemError.println("WARNING: store contains log file from too old version.");
                        break;
                    }
                    case NO_ACTIVE_FILE: 
                    case CLEAN: {
                        break;
                    }
                    default: {
                        this.systemError.print(ConsistencyCheckTool.lines("Active logical log detected, this might be a source of inconsistencies.", "Consider allowing the database to recover before running the consistency check.", "Consistency checking will continue, abort if you wish to perform recovery first.", "To perform recovery before checking consistency, use the '--recovery' flag."));
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.systemError.printf("Failure when checking for active logs: '%s', continuing as normal.%n", e);
            }
        }
    }

    private String determineStoreDirectory(Args arguments) throws ToolFailureException {
        List unprefixedArguments = arguments.orphans();
        if (unprefixedArguments.size() != 1) {
            throw new ToolFailureException(this.usage());
        }
        String storeDir = (String)unprefixedArguments.get(0);
        if (!new File(storeDir).isDirectory()) {
            throw new ToolFailureException(ConsistencyCheckTool.lines(String.format("'%s' is not a directory", storeDir)) + this.usage());
        }
        return storeDir;
    }

    private Config readTuningConfiguration(String storeDir, Args arguments) throws ToolFailureException {
        Map specifiedProperties = MapUtil.stringMap((String[])new String[0]);
        String propertyFilePath = arguments.get(CONFIG, null);
        if (propertyFilePath != null) {
            File propertyFile = new File(propertyFilePath);
            try {
                specifiedProperties = MapUtil.load((File)propertyFile);
            }
            catch (IOException e) {
                throw new ToolFailureException(String.format("Could not read configuration properties file [%s]", propertyFilePath), e);
            }
        }
        specifiedProperties.put(GraphDatabaseSettings.store_dir.name(), storeDir);
        return new Config(specifiedProperties, new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
    }

    private String usage() {
        return ConsistencyCheckTool.lines(Args.jarUsage(this.getClass(), (String[])new String[]{"[-propowner] [-recovery] [-config <neo4j.properties>] <storedir>"}), "WHERE:   <storedir>         is the path to the store to check", "         -recovery          to perform recovery on the store before checking", "         <neo4j.properties> is the location of an optional properties file", "                            containing tuning parameters for the consistency check");
    }

    private static String lines(String ... content) {
        StringBuilder result = new StringBuilder();
        for (String line : content) {
            result.append(line).append(System.getProperty("line.separator"));
        }
        return result.toString();
    }

    static class ToolFailureException
    extends Exception {
        ToolFailureException(String message) {
            super(message);
        }

        ToolFailureException(String message, Throwable cause) {
            super(message, cause);
        }

        void haltJVM() {
            System.err.println(this.getMessage());
            if (this.getCause() != null) {
                this.getCause().printStackTrace(System.err);
            }
            System.exit(1);
        }
    }
}

