/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.List;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.NodeLabelReader;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;

public class NodeCorrectlyIndexedCheck
implements RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
    private final IndexAccessors indexes;
    private final PropertyReader propertyReader;

    public NodeCorrectlyIndexedCheck(IndexAccessors indexes, PropertyReader propertyReader) {
        this.indexes = indexes;
        this.propertyReader = propertyReader;
    }

    @Override
    public void check(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
        Set<Long> labels = NodeLabelReader.getListOfLabels(record, records, engine);
        for (IndexRule indexRule : this.indexes.rules()) {
            List<PropertyBlock> properties;
            PropertyBlock property;
            if (!labels.contains(indexRule.getLabel()) || (property = this.propertyWithKey(properties = this.propertyReader.propertyBlocks(record), indexRule.getPropertyKey())) == null) continue;
            IndexReader reader = this.indexes.accessorFor(indexRule).newReader();
            Throwable throwable = null;
            try {
                Object propertyValue = this.propertyReader.propertyValue(property).value();
                PrimitiveLongIterator indexedNodeIds = reader.lookup(propertyValue);
                this.verifyNodeCorrectlyIndexed(record, engine, indexRule, propertyValue, indexedNodeIds);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    private void verifyNodeCorrectlyIndexed(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, IndexRule indexRule, Object propertyValue, PrimitiveLongIterator indexedNodeIds) {
        boolean matched = false;
        while (indexedNodeIds.hasNext()) {
            long nodeId = indexedNodeIds.next();
            if (nodeId == record.getId()) {
                matched = true;
                continue;
            }
            if (!indexRule.isConstraintIndex()) continue;
            engine.report().uniqueIndexNotUnique(indexRule, propertyValue, nodeId);
        }
        if (!matched) {
            engine.report().notIndexed(indexRule, propertyValue);
        }
    }

    private PropertyBlock propertyWithKey(List<PropertyBlock> propertyBlocks, int propertyKey) {
        for (PropertyBlock propertyBlock : propertyBlocks) {
            if (propertyBlock.getKeyIndexId() != propertyKey) continue;
            return propertyBlock;
        }
        return null;
    }

    @Override
    public void checkChange(NodeRecord oldRecord, NodeRecord newRecord, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, DiffRecordAccess records) {
        this.check(newRecord, engine, (RecordAccess)records);
    }
}

