/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.labels.LabelIdArray;

public class LabelChainWalker<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport>
implements ComparativeRecordChecker<RECORD, DynamicRecord, REPORT> {
    private final Validator<RECORD, REPORT> validator;
    private HashMap<Long, DynamicRecord> recordIds = new HashMap();
    private List<DynamicRecord> recordList = new ArrayList<DynamicRecord>();
    private boolean allInUse = true;

    public LabelChainWalker(Validator<RECORD, REPORT> validator) {
        this.validator = validator;
    }

    @Override
    public void checkReference(RECORD record, DynamicRecord dynamicRecord, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        this.recordIds.put(dynamicRecord.getId(), dynamicRecord);
        if (dynamicRecord.inUse()) {
            this.recordList.add(dynamicRecord);
        } else {
            this.allInUse = false;
            this.validator.onRecordNotInUse(dynamicRecord, engine);
        }
        long nextBlock = dynamicRecord.getNextBlock();
        if (Record.NO_NEXT_BLOCK.is(nextBlock)) {
            if (this.allInUse) {
                this.validator.onWellFormedChain(this.labelIds(this.recordList), engine, records);
            }
        } else if (this.recordIds.containsKey(nextBlock)) {
            this.validator.onRecordChainCycle(this.recordIds.get(nextBlock), engine);
        } else {
            engine.comparativeCheck(records.nodeLabels(nextBlock), this);
        }
    }

    private long[] labelIds(List<DynamicRecord> recordList) {
        long[] idArray = (long[])DynamicArrayStore.getRightArray((Pair)AbstractDynamicStore.readFullByteArrayFromHeavyRecords(recordList, (PropertyType)PropertyType.ARRAY));
        return LabelIdArray.stripNodeId((long[])idArray);
    }

    public static interface Validator<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> {
        public void onRecordNotInUse(DynamicRecord var1, CheckerEngine<RECORD, REPORT> var2);

        public void onRecordChainCycle(DynamicRecord var1, CheckerEngine<RECORD, REPORT> var2);

        public void onWellFormedChain(long[] var1, CheckerEngine<RECORD, REPORT> var2, RecordAccess var3);
    }
}

