/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

public class DiffRecordStore<R extends AbstractBaseRecord>
implements RecordStore<R>,
Iterable<Long> {
    private final RecordStore<R> actual;
    private final Map<Long, R> diff;
    private long highId = -1L;

    public DiffRecordStore(RecordStore<R> actual) {
        this.actual = actual;
        this.diff = new HashMap<Long, R>();
    }

    public String toString() {
        return "Diff/" + this.actual;
    }

    public void markDirty(long id) {
        if (!this.diff.containsKey(id)) {
            this.diff.put(id, null);
        }
    }

    public R forceGetRaw(R record) {
        if (this.diff.containsKey(record.getLongId())) {
            return (R)this.actual.forceGetRecord(record.getLongId());
        }
        return record;
    }

    public R forceGetRaw(long id) {
        return (R)this.actual.forceGetRecord(id);
    }

    public int getRecordHeaderSize() {
        return this.actual.getRecordHeaderSize();
    }

    public int getRecordSize() {
        return this.actual.getRecordSize();
    }

    public File getStorageFileName() {
        return this.actual.getStorageFileName();
    }

    public WindowPoolStats getWindowPoolStats() {
        return this.actual.getWindowPoolStats();
    }

    public long getHighId() {
        return Math.max(this.highId, this.actual.getHighId());
    }

    public long getHighestPossibleIdInUse() {
        return Math.max(this.highId, this.actual.getHighestPossibleIdInUse());
    }

    public long nextId() {
        return this.actual.nextId();
    }

    public R getRecord(long id) {
        return this.getRecord(id, false);
    }

    public R forceGetRecord(long id) {
        return this.getRecord(id, true);
    }

    private R getRecord(long id, boolean force) {
        AbstractBaseRecord record = (AbstractBaseRecord)this.diff.get(id);
        if (record == null) {
            return (R)(force ? this.actual.forceGetRecord(id) : this.actual.getRecord(id));
        }
        if (!force && !record.inUse()) {
            throw new InvalidRecordException(record.getClass().getSimpleName() + "[" + id + "] not in use");
        }
        return (R)record;
    }

    public Collection<R> getRecords(long id) {
        ArrayList<R> result = new ArrayList<R>();
        Long nextId = id;
        while (nextId != null) {
            R record = this.forceGetRecord(nextId);
            result.add(record);
            nextId = this.getNextRecordReference(record);
        }
        return result;
    }

    public Long getNextRecordReference(R record) {
        return this.actual.getNextRecordReference(record);
    }

    public void updateRecord(R record) {
        if (record.getLongId() > this.highId) {
            this.highId = record.getLongId();
        }
        this.diff.put(record.getLongId(), record);
    }

    public void forceUpdateRecord(R record) {
        this.updateRecord(record);
    }

    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, R record) throws FAILURE {
        this.actual.accept(new DispatchProcessor<FAILURE>(this, processor), record);
    }

    @Override
    public Iterator<Long> iterator() {
        return this.diff.keySet().iterator();
    }

    public void close() {
        this.diff.clear();
        this.actual.close();
    }

    public R getChangedRecord(long id) {
        return (R)((AbstractBaseRecord)this.diff.get(id));
    }

    public boolean hasChanges() {
        return !this.diff.isEmpty();
    }

    public int getNumberOfReservedLowIds() {
        return this.actual.getNumberOfReservedLowIds();
    }

    private static class DispatchProcessor<FAILURE extends Exception>
    extends RecordStore.Processor<FAILURE> {
        private final DiffRecordStore<?> diffStore;
        private final RecordStore.Processor<FAILURE> processor;

        DispatchProcessor(DiffRecordStore<?> diffStore, RecordStore.Processor<FAILURE> processor) {
            this.diffStore = diffStore;
            this.processor = processor;
        }

        public void processNode(RecordStore<NodeRecord> store, NodeRecord node) throws FAILURE {
            this.processor.processNode(this.diffStore, node);
        }

        public void processRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel) throws FAILURE {
            this.processor.processRelationship(this.diffStore, rel);
        }

        public void processProperty(RecordStore<PropertyRecord> store, PropertyRecord property) throws FAILURE {
            this.processor.processProperty(this.diffStore, property);
        }

        public void processString(RecordStore<DynamicRecord> store, DynamicRecord string, IdType idType) throws FAILURE {
            this.processor.processString(this.diffStore, string, idType);
        }

        public void processArray(RecordStore<DynamicRecord> store, DynamicRecord array) throws FAILURE {
            this.processor.processArray(this.diffStore, array);
        }

        public void processLabelArrayWithOwner(RecordStore<DynamicRecord> store, DynamicRecord array) throws FAILURE {
            this.processor.processLabelArrayWithOwner(this.diffStore, array);
        }

        public void processSchema(RecordStore<DynamicRecord> store, DynamicRecord schema) throws FAILURE {
            this.processor.processSchema(this.diffStore, schema);
        }

        public void processRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> store, RelationshipTypeTokenRecord record) throws FAILURE {
            this.processor.processRelationshipTypeToken(this.diffStore, record);
        }

        public void processPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> store, PropertyKeyTokenRecord record) throws FAILURE {
            this.processor.processPropertyKeyToken(this.diffStore, record);
        }

        public void processLabelToken(RecordStore<LabelTokenRecord> store, LabelTokenRecord record) throws FAILURE {
            this.processor.processLabelToken(this.diffStore, record);
        }
    }
}

