/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store.windowpool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.neo4j.consistency.store.windowpool.MappingStatisticsListener;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.kernel.impl.util.FileUtils;

public class LoggingStatisticsListener
implements MappingStatisticsListener {
    private final PrintWriter logWriter;

    public LoggingStatisticsListener(File fileName) throws FileNotFoundException {
        this.logWriter = FileUtils.newFilePrintWriter((File)fileName, (Charset)Charsets.UTF_8);
    }

    @Override
    public void onStatistics(File storeFileName, int acquiredPages, int mappedPages, long samplePeriod) {
        this.logWriter.printf("%s: In %s: %d pages acquired, %d pages mapped (%.2f%%) in %d ms%n", Format.date(), storeFileName.getName(), acquiredPages, mappedPages, 100.0 * (double)mappedPages / (double)acquiredPages, samplePeriod);
        this.logWriter.flush();
    }
}

