/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.util.Collection;
import org.neo4j.consistency.store.DiffRecordStore;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.store.TokenRecord;
import org.neo4j.kernel.impl.nioneo.xa.CommandRecordVisitor;

public class DiffStore
extends StoreAccess
implements CommandRecordVisitor {
    private NeoStoreRecord masterRecord;

    public DiffStore(NeoStore store) {
        super(store);
    }

    protected <R extends AbstractBaseRecord> RecordStore<R> wrapStore(RecordStore<R> store) {
        return new DiffRecordStore<R>(store);
    }

    protected <FAILURE extends Exception> void apply(RecordStore.Processor<FAILURE> processor, RecordStore<?> store) throws FAILURE {
        processor.applyById(store, (Iterable)((DiffRecordStore)store));
    }

    public void visitNode(NodeRecord record) {
        this.getNodeStore().forceUpdateRecord(record);
        record = this.getNodeStore().forceGetRaw(record);
        if (record.inUse()) {
            this.markProperty(record.getNextProp(), record.getId(), -1L);
            this.markRelationship(record.getNextRel());
        }
    }

    public void visitRelationship(RelationshipRecord record) {
        this.getRelationshipStore().forceUpdateRecord(record);
        record = this.getRelationshipStore().forceGetRaw(record);
        if (record.inUse()) {
            this.getNodeStore().markDirty(record.getFirstNode());
            this.getNodeStore().markDirty(record.getSecondNode());
            this.markProperty(record.getNextProp(), -1L, record.getId());
            this.markRelationship(record.getFirstNextRel());
            if (!record.isFirstInFirstChain()) {
                this.markRelationship(record.getFirstPrevRel());
            }
            this.markRelationship(record.getSecondNextRel());
            if (!record.isFirstInSecondChain()) {
                this.markRelationship(record.getSecondPrevRel());
            }
        }
    }

    private void markRelationship(long rel) {
        if (!Record.NO_NEXT_RELATIONSHIP.is(rel)) {
            this.getRelationshipStore().markDirty(rel);
        }
    }

    private void markRelationshipGroup(long group) {
        if (!Record.NO_NEXT_RELATIONSHIP.is(group)) {
            this.getRelationshipGroupStore().markDirty(group);
        }
    }

    private void markProperty(long prop, long nodeId, long relId) {
        if (!Record.NO_NEXT_PROPERTY.is(prop)) {
            RecordStore store = this.getPropertyStore();
            PropertyRecord record = (PropertyRecord)store.forceGetRaw(prop);
            if (nodeId != -1L) {
                record.setNodeId(nodeId);
            } else if (relId != -1L) {
                record.setRelId(relId);
            }
            store.updateRecord(record);
        }
    }

    public void visitProperty(PropertyRecord record) {
        this.getPropertyStore().forceUpdateRecord(record);
        this.updateDynamic(record);
        record = this.getPropertyStore().forceGetRaw(record);
        this.updateDynamic(record);
        if (record.inUse()) {
            this.markProperty(record.getNextProp(), record.getNodeId(), record.getRelId());
            this.markProperty(record.getPrevProp(), record.getNodeId(), record.getRelId());
        }
    }

    private void updateDynamic(PropertyRecord record) {
        for (PropertyBlock block : record.getPropertyBlocks()) {
            this.updateDynamic(block.getValueRecords());
        }
        this.updateDynamic(record.getDeletedRecords());
    }

    private void updateDynamic(Collection<DynamicRecord> records) {
        for (DynamicRecord record : records) {
            RecordStore store = record.getType() == PropertyType.STRING.intValue() ? this.getStringStore() : this.getArrayStore();
            store.forceUpdateRecord(record);
            if (Record.NO_NEXT_BLOCK.is(record.getNextBlock())) continue;
            this.getBlockStore(record.getType()).markDirty(record.getNextBlock());
        }
    }

    private DiffRecordStore getBlockStore(int type) {
        if (type == PropertyType.STRING.intValue()) {
            return this.getStringStore();
        }
        return this.getArrayStore();
    }

    public void visitPropertyKeyToken(PropertyKeyTokenRecord record) {
        this.visitNameStore(this.getPropertyKeyTokenStore(), (RecordStore<DynamicRecord>)this.getPropertyKeyNameStore(), record);
    }

    public void visitRelationshipTypeToken(RelationshipTypeTokenRecord record) {
        this.visitNameStore(this.getRelationshipTypeTokenStore(), (RecordStore<DynamicRecord>)this.getRelationshipTypeNameStore(), record);
    }

    public void visitLabelToken(LabelTokenRecord record) {
        this.visitNameStore(this.getLabelTokenStore(), (RecordStore<DynamicRecord>)this.getLabelNameStore(), record);
    }

    private <R extends TokenRecord> void visitNameStore(RecordStore<R> store, RecordStore<DynamicRecord> nameStore, R record) {
        store.forceUpdateRecord(record);
        for (DynamicRecord key : record.getNameRecords()) {
            nameStore.forceUpdateRecord((AbstractBaseRecord)key);
        }
    }

    public void visitNeoStore(NeoStoreRecord record) {
        this.masterRecord = record;
    }

    public void visitSchemaRule(Collection<DynamicRecord> records) {
        for (DynamicRecord record : records) {
            this.getSchemaStore().forceUpdateRecord(record);
        }
    }

    public void visitRelationshipGroup(RelationshipGroupRecord record) {
        this.getRelationshipGroupStore().forceUpdateRecord(record);
        record = this.getRelationshipGroupStore().forceGetRaw(record);
        if (record.inUse()) {
            this.markRelationship(record.getFirstOut());
            this.markRelationship(record.getFirstIn());
            this.markRelationship(record.getFirstLoop());
            this.markRelationshipGroup(record.getNext());
        }
    }

    public DiffRecordStore<DynamicRecord> getSchemaStore() {
        return (DiffRecordStore)super.getSchemaStore();
    }

    public DiffRecordStore<NodeRecord> getNodeStore() {
        return (DiffRecordStore)super.getNodeStore();
    }

    public DiffRecordStore<RelationshipRecord> getRelationshipStore() {
        return (DiffRecordStore)super.getRelationshipStore();
    }

    public DiffRecordStore<RelationshipGroupRecord> getRelationshipGroupStore() {
        return (DiffRecordStore)super.getRelationshipGroupStore();
    }

    public DiffRecordStore<PropertyRecord> getPropertyStore() {
        return (DiffRecordStore)super.getPropertyStore();
    }

    public DiffRecordStore<DynamicRecord> getStringStore() {
        return (DiffRecordStore)super.getStringStore();
    }

    public DiffRecordStore<DynamicRecord> getArrayStore() {
        return (DiffRecordStore)super.getArrayStore();
    }

    public DiffRecordStore<RelationshipTypeTokenRecord> getRelationshipTypeTokenStore() {
        return (DiffRecordStore)super.getRelationshipTypeTokenStore();
    }

    public DiffRecordStore<DynamicRecord> getRelationshipTypeNameStore() {
        return (DiffRecordStore)super.getRelationshipTypeNameStore();
    }

    public DiffRecordStore<PropertyKeyTokenRecord> getPropertyKeyTokenStore() {
        return (DiffRecordStore)super.getPropertyKeyTokenStore();
    }

    public DiffRecordStore<DynamicRecord> getPropertyKeyNameStore() {
        return (DiffRecordStore)super.getPropertyKeyNameStore();
    }

    public NeoStoreRecord getMasterRecord() {
        return this.masterRecord;
    }
}

