/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.consistency.store.synthetic.LabelScanDocument;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;

public class ConsistencyReporter
implements ConsistencyReport.Reporter {
    private static final ProxyFactory<ConsistencyReport.SchemaConsistencyReport> SCHEMA_REPORT = ProxyFactory.create(ConsistencyReport.SchemaConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.NodeConsistencyReport> NODE_REPORT = ProxyFactory.create(ConsistencyReport.NodeConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.LabelsMatchReport> LABEL_MATCH_REPORT = ProxyFactory.create(ConsistencyReport.LabelsMatchReport.class);
    private static final ProxyFactory<ConsistencyReport.RelationshipConsistencyReport> RELATIONSHIP_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.PropertyConsistencyReport> PROPERTY_REPORT = ProxyFactory.create(ConsistencyReport.PropertyConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.RelationshipTypeConsistencyReport> RELATIONSHIP_TYPE_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipTypeConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.LabelTokenConsistencyReport> LABEL_KEY_REPORT = ProxyFactory.create(ConsistencyReport.LabelTokenConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.PropertyKeyTokenConsistencyReport> PROPERTY_KEY_REPORT = ProxyFactory.create(ConsistencyReport.PropertyKeyTokenConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.DynamicConsistencyReport> DYNAMIC_REPORT = ProxyFactory.create(ConsistencyReport.DynamicConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.DynamicLabelConsistencyReport> DYNAMIC_LABEL_REPORT = ProxyFactory.create(ConsistencyReport.DynamicLabelConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.LabelScanConsistencyReport> LABEL_SCAN_REPORT = ProxyFactory.create(ConsistencyReport.LabelScanConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.IndexConsistencyReport> INDEX = ProxyFactory.create(ConsistencyReport.IndexConsistencyReport.class);
    private final DiffRecordAccess records;
    private final InconsistencyReport report;

    public ConsistencyReporter(DiffRecordAccess records, InconsistencyReport report) {
        this.records = records;
        this.report = report;
    }

    private <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> void dispatch(RecordType type, ProxyFactory<REPORT> factory, RECORD record, RecordCheck<RECORD, REPORT> checker) {
        ReportHandler handler = new ReportHandler(this.report, factory, type, record);
        try {
            checker.check(record, handler, this.records);
        }
        catch (Exception e) {
            handler.report.error(type, record, "Failed to check record: " + e.getMessage(), new Object[0]);
        }
        handler.updateSummary();
    }

    private <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> void dispatchChange(RecordType type, ProxyFactory<REPORT> factory, RECORD oldRecord, RECORD newRecord, RecordCheck<RECORD, REPORT> checker) {
        DiffReportHandler handler = new DiffReportHandler(this.report, factory, type, oldRecord, newRecord);
        try {
            checker.checkChange(oldRecord, newRecord, handler, this.records);
        }
        catch (Exception e) {
            handler.report.error(type, oldRecord, newRecord, "Failed to check record: " + e.getMessage(), new Object[0]);
        }
        handler.updateSummary();
    }

    static void dispatchReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord referenced, RecordAccess records) {
        ReportInvocationHandler handler = (ReportInvocationHandler)engine;
        handler.checkReference(engine, checker, referenced, records);
        handler.updateSummary();
    }

    static String pendingCheckToString(CheckerEngine engine, ComparativeRecordChecker checker) {
        ReportInvocationHandler handler = (ReportInvocationHandler)engine;
        return handler.pendingCheckToString(checker);
    }

    static void dispatchChangeReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord oldReferenced, AbstractBaseRecord newReferenced, RecordAccess records) {
        ReportInvocationHandler handler = (ReportInvocationHandler)engine;
        handler.checkDiffReference(engine, checker, oldReferenced, newReferenced, records);
        handler.updateSummary();
    }

    static void dispatchSkip(CheckerEngine engine) {
        ((ReportInvocationHandler)engine).updateSummary();
    }

    @Override
    public void forSchema(DynamicRecord schema, RecordCheck<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> checker) {
        this.dispatch(RecordType.SCHEMA, SCHEMA_REPORT, schema, checker);
    }

    @Override
    public void forSchemaChange(DynamicRecord oldSchema, DynamicRecord newSchema, RecordCheck<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> checker) {
        this.dispatchChange(RecordType.SCHEMA, SCHEMA_REPORT, oldSchema, newSchema, checker);
    }

    @Override
    public void forNode(NodeRecord node, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.dispatch(RecordType.NODE, NODE_REPORT, node, checker);
    }

    @Override
    public void forNodeChange(NodeRecord oldNode, NodeRecord newNode, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.dispatchChange(RecordType.NODE, NODE_REPORT, oldNode, newNode, checker);
    }

    @Override
    public void forRelationship(RelationshipRecord relationship, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        this.dispatch(RecordType.RELATIONSHIP, RELATIONSHIP_REPORT, relationship, checker);
    }

    @Override
    public void forRelationshipChange(RelationshipRecord oldRelationship, RelationshipRecord newRelationship, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        this.dispatchChange(RecordType.RELATIONSHIP, RELATIONSHIP_REPORT, oldRelationship, newRelationship, checker);
    }

    @Override
    public void forProperty(PropertyRecord property, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.dispatch(RecordType.PROPERTY, PROPERTY_REPORT, property, checker);
    }

    @Override
    public void forPropertyChange(PropertyRecord oldProperty, PropertyRecord newProperty, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.dispatchChange(RecordType.PROPERTY, PROPERTY_REPORT, oldProperty, newProperty, checker);
    }

    @Override
    public void forRelationshipTypeName(RelationshipTypeTokenRecord relationshipTypeTokenRecord, RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
        this.dispatch(RecordType.RELATIONSHIP_TYPE, RELATIONSHIP_TYPE_REPORT, relationshipTypeTokenRecord, checker);
    }

    @Override
    public void forRelationshipTypeNameChange(RelationshipTypeTokenRecord oldType, RelationshipTypeTokenRecord newType, RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
        this.dispatchChange(RecordType.RELATIONSHIP_TYPE, RELATIONSHIP_TYPE_REPORT, oldType, newType, checker);
    }

    @Override
    public void forLabelName(LabelTokenRecord label, RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
        this.dispatch(RecordType.LABEL, LABEL_KEY_REPORT, label, checker);
    }

    @Override
    public void forNodeLabelScan(LabelScanDocument document, RecordCheck<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> checker) {
        this.dispatch(RecordType.LABEL_SCAN_DOCUMENT, LABEL_SCAN_REPORT, document, checker);
    }

    @Override
    public void forIndexEntry(IndexEntry entry, RecordCheck<IndexEntry, ConsistencyReport.IndexConsistencyReport> checker) {
        this.dispatch(RecordType.INDEX, INDEX, entry, checker);
    }

    @Override
    public void forNodeLabelMatch(NodeRecord nodeRecord, RecordCheck<NodeRecord, ConsistencyReport.LabelsMatchReport> nodeLabelCheck) {
        this.dispatch(RecordType.NODE, LABEL_MATCH_REPORT, nodeRecord, nodeLabelCheck);
    }

    @Override
    public void forLabelNameChange(LabelTokenRecord oldLabel, LabelTokenRecord newLabel, RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
        this.dispatchChange(RecordType.LABEL, LABEL_KEY_REPORT, oldLabel, newLabel, checker);
    }

    @Override
    public void forPropertyKey(PropertyKeyTokenRecord key, RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
        this.dispatch(RecordType.PROPERTY_KEY, PROPERTY_KEY_REPORT, key, checker);
    }

    @Override
    public void forPropertyKeyChange(PropertyKeyTokenRecord oldKey, PropertyKeyTokenRecord newKey, RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
        this.dispatchChange(RecordType.PROPERTY_KEY, PROPERTY_KEY_REPORT, oldKey, newKey, checker);
    }

    @Override
    public void forDynamicBlock(RecordType type, DynamicRecord record, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.dispatch(type, DYNAMIC_REPORT, record, checker);
    }

    @Override
    public void forDynamicBlockChange(RecordType type, DynamicRecord oldRecord, DynamicRecord newRecord, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.dispatchChange(type, DYNAMIC_REPORT, oldRecord, newRecord, checker);
    }

    @Override
    public void forDynamicLabelBlock(RecordType type, DynamicRecord record, RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> checker) {
        this.dispatch(type, DYNAMIC_LABEL_REPORT, record, checker);
    }

    @Override
    public void forDynamicLabelBlockChange(RecordType type, DynamicRecord oldRecord, DynamicRecord newRecord, RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> checker) {
        this.dispatchChange(type, DYNAMIC_LABEL_REPORT, oldRecord, newRecord, checker);
    }

    static class ProxyFactory<T> {
        private Constructor<? extends T> constructor;

        ProxyFactory(Class<T> type) throws LinkageError {
            try {
                this.constructor = Proxy.getProxyClass(ConsistencyReporter.class.getClassLoader(), type).getConstructor(InvocationHandler.class);
            }
            catch (NoSuchMethodException e) {
                throw (LinkageError)Exceptions.withCause((Throwable)new LinkageError("Cannot access Proxy constructor for " + type.getName()), (Throwable)e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + Arrays.asList(this.constructor.getDeclaringClass().getInterfaces());
        }

        public T create(InvocationHandler handler) {
            try {
                return this.constructor.newInstance(handler);
            }
            catch (InvocationTargetException e) {
                throw Exceptions.launderedException((Throwable)e);
            }
            catch (Exception e) {
                throw new LinkageError("Failed to create proxy instance");
            }
        }

        public static <T> ProxyFactory<T> create(Class<T> type) {
            return new ProxyFactory<T>(type);
        }
    }

    private static class DiffReportHandler<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport>
    extends ReportInvocationHandler<RECORD, REPORT> {
        private final AbstractBaseRecord oldRecord;
        private final AbstractBaseRecord newRecord;

        private DiffReportHandler(InconsistencyReport report, ProxyFactory<REPORT> factory, RecordType type, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord) {
            super(report, factory, type);
            this.oldRecord = oldRecord;
            this.newRecord = newRecord;
        }

        @Override
        long recordId() {
            return this.newRecord.getLongId();
        }

        @Override
        protected void logError(String message, Object[] args) {
            this.report.error(this.type, this.oldRecord, this.newRecord, message, args);
        }

        @Override
        protected void logWarning(String message, Object[] args) {
            this.report.warning(this.type, this.oldRecord, this.newRecord, message, args);
        }

        @Override
        void checkReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord referenced, RecordAccess records) {
            checker.checkReference(this.newRecord, referenced, this, records);
        }

        @Override
        void checkDiffReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord oldReferenced, AbstractBaseRecord newReferenced, RecordAccess records) {
            checker.checkReference(this.newRecord, newReferenced, this, records);
        }
    }

    static class ReportHandler<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport>
    extends ReportInvocationHandler<RECORD, REPORT> {
        private final AbstractBaseRecord record;

        ReportHandler(InconsistencyReport report, ProxyFactory<REPORT> factory, RecordType type, AbstractBaseRecord record) {
            super(report, factory, type);
            this.record = record;
        }

        @Override
        long recordId() {
            return this.record.getLongId();
        }

        @Override
        protected void logError(String message, Object[] args) {
            this.report.error(this.type, this.record, message, args);
        }

        @Override
        protected void logWarning(String message, Object[] args) {
            this.report.warning(this.type, this.record, message, args);
        }

        @Override
        void checkReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord referenced, RecordAccess records) {
            checker.checkReference(this.record, referenced, this, records);
        }

        @Override
        void checkDiffReference(CheckerEngine engine, ComparativeRecordChecker checker, AbstractBaseRecord oldReferenced, AbstractBaseRecord newReferenced, RecordAccess records) {
            checker.checkReference(this.record, newReferenced, this, records);
        }
    }

    private static abstract class ReportInvocationHandler<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport>
    implements CheckerEngine<RECORD, REPORT>,
    InvocationHandler {
        final InconsistencyReport report;
        private final ProxyFactory<REPORT> factory;
        final RecordType type;
        private short errors = 0;
        private short warnings = 0;
        private short references = 1;

        private ReportInvocationHandler(InconsistencyReport report, ProxyFactory<REPORT> factory, RecordType type) {
            this.report = report;
            this.factory = factory;
            this.type = type;
        }

        synchronized void updateSummary() {
            this.references = (short)(this.references - 1);
            if (this.references == 0) {
                this.report.updateSummary(this.type, this.errors, this.warnings);
            }
        }

        String pendingCheckToString(ComparativeRecordChecker checker) {
            String checkName;
            try {
                if (checker.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                    checkName = checker.getClass().getSimpleName();
                    if (checkName.length() == 0) {
                        checkName = checker.getClass().getName();
                    }
                } else {
                    checkName = checker.toString();
                }
            }
            catch (NoSuchMethodException e) {
                checkName = checker.toString();
            }
            return String.format("ReferenceCheck{%s[%s]/%s}", new Object[]{this.type, this.recordId(), checkName});
        }

        abstract long recordId();

        @Override
        public <REFERRED extends AbstractBaseRecord> void comparativeCheck(RecordReference<REFERRED> reference, ComparativeRecordChecker<RECORD, ? super REFERRED, REPORT> checker) {
            this.references = (short)(this.references + 1);
            reference.dispatch(new PendingReferenceCheck(this, checker));
        }

        @Override
        public REPORT report() {
            return (REPORT)((ConsistencyReport)this.factory.create(this));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Documented annotation = method.getAnnotation(Documented.class);
            String message = annotation != null && !"".equals(annotation.value()) ? annotation.value() : method.getName();
            if (method.getAnnotation(ConsistencyReport.Warning.class) == null) {
                this.errors = (short)(this.errors + 1);
                this.logError(message, args);
            } else {
                this.warnings = (short)(this.warnings + 1);
                this.logWarning(message, args);
            }
            return null;
        }

        protected abstract void logError(String var1, Object[] var2);

        protected abstract void logWarning(String var1, Object[] var2);

        abstract void checkReference(CheckerEngine var1, ComparativeRecordChecker var2, AbstractBaseRecord var3, RecordAccess var4);

        abstract void checkDiffReference(CheckerEngine var1, ComparativeRecordChecker var2, AbstractBaseRecord var3, AbstractBaseRecord var4, RecordAccess var5);
    }
}

