/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.consistency.checking.SchemaRecordCheck;
import org.neo4j.consistency.checking.full.IndexCheck;
import org.neo4j.consistency.checking.full.IterableStore;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.NodeToLabelIndexesProcessor;
import org.neo4j.consistency.checking.full.NodeToLabelScanRecordProcessor;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.full.RecordScanner;
import org.neo4j.consistency.checking.full.SchemaStoreProcessorTask;
import org.neo4j.consistency.checking.full.StoppableRunnable;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.StoreProcessorTask;
import org.neo4j.consistency.checking.full.TaskExecutionOrder;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.checking.index.IndexEntryProcessor;
import org.neo4j.consistency.checking.index.IndexIterator;
import org.neo4j.consistency.checking.labelscan.LabelScanCheck;
import org.neo4j.consistency.checking.labelscan.LabelScanDocumentProcessor;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.direct.NodeLabelRange;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;

public class ConsistencyCheckTasks {
    private final ProgressMonitorFactory.MultiPartBuilder progress;
    private final TaskExecutionOrder order;
    private final StoreProcessor processor;

    ConsistencyCheckTasks(ProgressMonitorFactory.MultiPartBuilder progress, TaskExecutionOrder order, StoreProcessor processor) {
        this.progress = progress;
        this.order = order;
        this.processor = processor;
    }

    public List<StoppableRunnable> createTasks(StoreAccess nativeStores, LabelScanStore labelScanStore, IndexAccessors indexes, MultiPassStore.Factory multiPass, ConsistencyReporter reporter, boolean checkLabelScanStore, boolean checkIndexes) {
        ArrayList<StoppableRunnable> tasks = new ArrayList<StoppableRunnable>();
        tasks.add(this.create(nativeStores.getNodeStore(), multiPass.processors(MultiPassStore.PROPERTIES, MultiPassStore.RELATIONSHIPS)));
        tasks.add(this.create(nativeStores.getRelationshipStore(), multiPass.processors(MultiPassStore.NODES, MultiPassStore.PROPERTIES, MultiPassStore.RELATIONSHIPS)));
        tasks.add(this.create(nativeStores.getPropertyStore(), multiPass.processors(MultiPassStore.PROPERTIES, MultiPassStore.STRINGS, MultiPassStore.ARRAYS)));
        tasks.add(this.create(nativeStores.getStringStore(), multiPass.processors(MultiPassStore.STRINGS)));
        tasks.add(this.create(nativeStores.getArrayStore(), multiPass.processors(MultiPassStore.ARRAYS)));
        tasks.add(this.create(nativeStores.getSchemaStore()));
        SchemaRecordCheck schemaCheck = new SchemaRecordCheck((SchemaRuleAccess)new SchemaStorage(nativeStores.getSchemaStore()));
        tasks.add(new SchemaStoreProcessorTask(nativeStores.getSchemaStore(), "check_rules", schemaCheck, this.progress, this.order, this.processor, this.processor));
        tasks.add(new SchemaStoreProcessorTask(nativeStores.getSchemaStore(), "check_obligations", schemaCheck.forObligationChecking(), this.progress, this.order, this.processor, this.processor));
        tasks.add(this.create(nativeStores.getRelationshipTypeTokenStore()));
        tasks.add(this.create(nativeStores.getPropertyKeyTokenStore()));
        tasks.add(this.create(nativeStores.getLabelTokenStore()));
        tasks.add(this.create(nativeStores.getRelationshipTypeNameStore()));
        tasks.add(this.create(nativeStores.getPropertyKeyNameStore()));
        tasks.add(this.create(nativeStores.getLabelNameStore()));
        tasks.add(this.create(nativeStores.getNodeDynamicLabelStore()));
        if (checkLabelScanStore) {
            tasks.add(new RecordScanner<NodeRecord>(new IterableStore(nativeStores.getNodeStore()), "NodeStoreToLabelScanStore", this.progress, new NodeToLabelScanRecordProcessor(reporter, labelScanStore)));
        }
        if (checkIndexes) {
            tasks.add(new RecordScanner<NodeRecord>(new IterableStore(nativeStores.getNodeStore()), "NodeStoreToIndexes", this.progress, new NodeToLabelIndexesProcessor(reporter, indexes, new PropertyReader((PropertyStore)nativeStores.getPropertyStore()))));
        }
        int iPass = 0;
        for (ConsistencyReporter filteredReporter : multiPass.reporters(this.order, MultiPassStore.NODES)) {
            if (checkLabelScanStore) {
                tasks.add(new RecordScanner<NodeLabelRange>((BoundedIterable<NodeLabelRange>)labelScanStore.newAllEntriesReader(), String.format("LabelScanStore_%d", iPass), this.progress, new LabelScanDocumentProcessor(filteredReporter, new LabelScanCheck())));
            }
            if (checkIndexes) {
                for (IndexRule indexRule : indexes.rules()) {
                    tasks.add(new RecordScanner<Long>(new IndexIterator(indexes.accessorFor(indexRule)), String.format("Index_%d_%d", indexRule.getId(), iPass), this.progress, new IndexEntryProcessor(filteredReporter, new IndexCheck(indexRule))));
                }
            }
            ++iPass;
        }
        return tasks;
    }

    <RECORD extends AbstractBaseRecord> StoreProcessorTask<RECORD> create(RecordStore<RECORD> input) {
        return new StoreProcessorTask<RECORD>(input, this.progress, this.order, this.processor, this.processor);
    }

    <RECORD extends AbstractBaseRecord> StoreProcessorTask<RECORD> create(RecordStore<RECORD> input, StoreProcessor[] processors) {
        return new StoreProcessorTask<RECORD>(input, this.progress, this.order, this.processor, processors);
    }
}

