/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.lang.reflect.Array;
import java.util.List;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyCheckTasks;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.OwnerCheck;
import org.neo4j.consistency.checking.full.StoppableRunnable;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.TaskExecutionOrder;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.store.CacheSmallStoresRecordAccess;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.util.StringLogger;

public class FullCheck {
    private final boolean checkPropertyOwners;
    private final boolean checkLabelScanStore;
    private final boolean checkIndexes;
    private final TaskExecutionOrder order;
    private final ProgressMonitorFactory progressFactory;
    private final Long totalMappedMemory;
    private final boolean checkGraph;

    public FullCheck(Config tuningConfiguration, ProgressMonitorFactory progressFactory) {
        this.checkPropertyOwners = (Boolean)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_property_owners);
        this.checkLabelScanStore = (Boolean)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_label_scan_store);
        this.checkIndexes = (Boolean)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_indexes);
        this.checkGraph = (Boolean)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_graph);
        this.order = (TaskExecutionOrder)((Object)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_execution_order));
        this.totalMappedMemory = (Long)tuningConfiguration.get(GraphDatabaseSettings.all_stores_total_mapped_memory_size);
        this.progressFactory = progressFactory;
    }

    public ConsistencySummaryStatistics execute(DirectStoreAccess stores, StringLogger logger) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary = new ConsistencySummaryStatistics();
        InconsistencyReport report = new InconsistencyReport(new InconsistencyMessageLogger(logger), summary);
        OwnerCheck ownerCheck = new OwnerCheck(this.checkPropertyOwners, new DynamicStore[0]);
        this.execute(stores, ownerCheck, FullCheck.recordAccess(stores.nativeStores()), report);
        ownerCheck.scanForOrphanChains(this.progressFactory);
        if (!summary.isConsistent()) {
            logger.logMessage("Inconsistencies found: " + summary);
        }
        return summary;
    }

    void execute(DirectStoreAccess directStoreAccess, CheckDecorator decorator, DiffRecordAccess recordAccess, InconsistencyReport report) throws ConsistencyCheckIncompleteException {
        ConsistencyReporter reporter = new ConsistencyReporter(recordAccess, report);
        StoreProcessor processEverything = new StoreProcessor(decorator, reporter);
        ProgressMonitorFactory.MultiPartBuilder progress = this.progressFactory.multipleParts("Full consistency check");
        StoreAccess nativeStores = directStoreAccess.nativeStores();
        try (IndexAccessors indexes = new IndexAccessors(directStoreAccess.indexes(), (RecordStore<DynamicRecord>)nativeStores.getSchemaStore());){
            MultiPassStore.Factory multiPass = new MultiPassStore.Factory(decorator, this.totalMappedMemory, nativeStores, recordAccess, report);
            List<StoppableRunnable> tasks = new ConsistencyCheckTasks(progress, this.order, processEverything).createTasks(nativeStores, directStoreAccess.labelScanStore(), indexes, multiPass, reporter, this.checkLabelScanStore, this.checkIndexes, this.checkGraph);
            this.order.execute(tasks, progress.build());
        }
        catch (Exception e) {
            throw new ConsistencyCheckIncompleteException(e);
        }
    }

    static DiffRecordAccess recordAccess(StoreAccess store) {
        return new CacheSmallStoresRecordAccess(new DirectRecordAccess(store), (PropertyKeyTokenRecord[])FullCheck.readAllRecords(PropertyKeyTokenRecord.class, (RecordStore)store.getPropertyKeyTokenStore()), (RelationshipTypeTokenRecord[])FullCheck.readAllRecords(RelationshipTypeTokenRecord.class, (RecordStore)store.getRelationshipTypeTokenStore()), (LabelTokenRecord[])FullCheck.readAllRecords(LabelTokenRecord.class, (RecordStore)store.getLabelTokenStore()));
    }

    private static <T extends AbstractBaseRecord> T[] readAllRecords(Class<T> type, RecordStore<T> store) {
        AbstractBaseRecord[] records = (AbstractBaseRecord[])Array.newInstance(type, (int)store.getHighId());
        for (int i = 0; i < records.length; ++i) {
            records[i] = store.forceGetRecord((long)i);
        }
        return records;
    }
}

