/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store.windowpool;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;

class MappedWindow
implements PersistenceWindow {
    private final long startRecordId;
    private final Buffer buffer;
    private final int recordsPerPage;
    private final int recordSize;
    private static final boolean I_AM_SURE_THERE_ARE_NO_REFERENCES_TO_HERE = false;

    public MappedWindow(int recordsPerPage, int recordSize, long startRecordId, MappedByteBuffer mappedBuffer) {
        this.recordsPerPage = recordsPerPage;
        this.recordSize = recordSize;
        this.startRecordId = startRecordId;
        this.buffer = new Buffer((PersistenceWindow)this, (ByteBuffer)mappedBuffer);
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Buffer getOffsettedBuffer(long id) {
        int offset = (int)(id - this.startRecordId) * this.recordSize;
        this.buffer.setOffset(offset);
        return this.buffer;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public long position() {
        return this.startRecordId;
    }

    public int size() {
        return this.recordsPerPage;
    }

    public void force() {
    }

    public void close() {
    }
}

