/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.consistency.checking.schema.IndexRules;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;

public class IndexAccessors
implements Closeable {
    private final Map<Long, IndexAccessor> accessors = new HashMap<Long, IndexAccessor>();
    private final List<IndexRule> indexRules = new ArrayList<IndexRule>();

    public IndexAccessors(SchemaIndexProvider provider, RecordStore<DynamicRecord> schemaStore) throws IOException, MalformedSchemaRuleException {
        Iterator<IndexRule> rules = IndexRules.loadAllIndexRules(schemaStore).iterator();
        while (true) {
            try {
                while (rules.hasNext()) {
                    IndexRule indexRule = rules.next();
                    if (InternalIndexState.ONLINE != provider.getInitialState(indexRule.getId())) continue;
                    this.indexRules.add(indexRule);
                }
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
        for (IndexRule indexRule : this.indexRules) {
            this.accessors.put(indexRule.getId(), provider.getOnlineAccessor(indexRule.getId(), new IndexConfiguration(indexRule.isConstraintIndex())));
        }
    }

    public IndexAccessor accessorFor(IndexRule indexRule) {
        return this.accessors.get(indexRule.getId());
    }

    public Iterable<IndexRule> rules() {
        return this.indexRules;
    }

    @Override
    public void close() throws IOException {
        for (IndexAccessor accessor : this.accessors.values()) {
            accessor.close();
        }
        this.accessors.clear();
        this.indexRules.clear();
    }
}

