/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.full.StoppableRunnable;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.TaskExecutionOrder;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;

class StoreProcessorTask<R extends AbstractBaseRecord>
implements StoppableRunnable {
    private final RecordStore<R> store;
    private final StoreProcessor[] processors;
    private final ProgressListener[] progressListeners;

    StoreProcessorTask(RecordStore<R> store, ProgressMonitorFactory.MultiPartBuilder builder, TaskExecutionOrder order, StoreProcessor singlePassProcessor, StoreProcessor ... multiPassProcessors) {
        this(store, "", builder, order, singlePassProcessor, multiPassProcessors);
    }

    StoreProcessorTask(RecordStore<R> store, String builderPrefix, ProgressMonitorFactory.MultiPartBuilder builder, TaskExecutionOrder order, StoreProcessor singlePassProcessor, StoreProcessor ... multiPassProcessors) {
        String sanitizedBuilderPrefix;
        this.store = store;
        String storeFileName = store.getStorageFileName().getName();
        String string = sanitizedBuilderPrefix = builderPrefix == null ? "" : builderPrefix;
        if (order == TaskExecutionOrder.MULTI_PASS) {
            this.processors = multiPassProcessors;
            this.progressListeners = new ProgressListener[multiPassProcessors.length];
            for (int i = 0; i < multiPassProcessors.length; ++i) {
                String partName = this.indexedPartName(storeFileName, sanitizedBuilderPrefix, i);
                this.progressListeners[i] = builder.progressForPart(partName, store.getHighId());
            }
        } else {
            this.processors = new StoreProcessor[]{singlePassProcessor};
            String partName = this.partName(storeFileName, sanitizedBuilderPrefix);
            this.progressListeners = new ProgressListener[]{builder.progressForPart(partName, store.getHighId())};
        }
    }

    private String partName(String storeFileName, String builderPrefix) {
        return builderPrefix.length() == 0 ? storeFileName : String.format("%s_run_%s", storeFileName, builderPrefix);
    }

    private String indexedPartName(String storeFileName, String prefix, int i) {
        if (prefix.length() != 0) {
            prefix = prefix + "_";
        }
        return String.format("%s_pass_%s%d", storeFileName, prefix, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = 0; i < this.processors.length; ++i) {
            StoreProcessor processor = this.processors[i];
            this.beforeProcessing(processor);
            try {
                processor.applyFiltered(this.store, this.progressListeners[i], new Predicate[0]);
                continue;
            }
            catch (Throwable e) {
                this.progressListeners[i].failed(e);
                continue;
            }
            finally {
                this.afterProcessing(processor);
            }
        }
    }

    protected void beforeProcessing(StoreProcessor processor) {
    }

    protected void afterProcessing(StoreProcessor processor) {
    }

    @Override
    public void stopScanning() {
        this.processors[0].stopScanning();
    }
}

