/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.StoreProcessorTask;
import org.neo4j.helpers.progress.Completion;

public enum TaskExecutionOrder {
    MULTI_THREADED{

        @Override
        void execute(List<StoreProcessorTask> tasks, Completion completion) throws ConsistencyCheckIncompleteException {
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            for (StoreProcessorTask task : tasks) {
                executor.submit(task);
            }
            try {
                completion.await(7L, TimeUnit.DAYS);
            }
            catch (Exception e) {
                tasks.get(0).stopScanning();
                throw new ConsistencyCheckIncompleteException(e);
            }
            finally {
                executor.shutdown();
                try {
                    executor.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {}
            }
        }
    }
    ,
    SINGLE_THREADED{

        @Override
        void execute(List<StoreProcessorTask> tasks, Completion completion) throws ConsistencyCheckIncompleteException {
            try {
                for (StoreProcessorTask task : tasks) {
                    task.run();
                }
                completion.await(0L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new ConsistencyCheckIncompleteException(e);
            }
        }
    }
    ,
    MULTI_PASS{

        @Override
        void execute(List<StoreProcessorTask> tasks, Completion completion) throws ConsistencyCheckIncompleteException {
            try {
                for (StoreProcessorTask task : tasks) {
                    task.run();
                }
                completion.await(0L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new ConsistencyCheckIncompleteException(e);
            }
        }
    };


    abstract void execute(List<StoreProcessorTask> var1, Completion var2) throws ConsistencyCheckIncompleteException;
}

