/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.FilteringRecordAccess;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;

public enum MultiPassStore {
    NODES{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getNodeStore();
        }
    }
    ,
    RELATIONSHIPS{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getRelationshipStore();
        }
    }
    ,
    PROPERTIES{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getPropertyStore();
        }
    }
    ,
    STRINGS{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getNodeStore();
        }
    }
    ,
    ARRAYS{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getNodeStore();
        }
    };


    public static boolean recordInCurrentPass(long id, int iPass, long recordsPerPass) {
        return id >= (long)iPass * recordsPerPass && id < (long)(iPass + 1) * recordsPerPass;
    }

    public List<DiffRecordAccess> multiPassFilters(long memoryPerPass, StoreAccess storeAccess, DiffRecordAccess recordAccess, MultiPassStore[] stores) {
        ArrayList<DiffRecordAccess> filteringStores = new ArrayList<DiffRecordAccess>();
        RecordStore recordStore = this.getRecordStore(storeAccess);
        long recordsPerPass = memoryPerPass / (long)recordStore.getRecordSize();
        long highId = recordStore.getHighId();
        int iPass = 0;
        while ((long)iPass * recordsPerPass <= highId) {
            filteringStores.add(new FilteringRecordAccess(recordAccess, iPass, recordsPerPass, this, stores));
            ++iPass;
        }
        return filteringStores;
    }

    abstract RecordStore getRecordStore(StoreAccess var1);

    static class Factory {
        private final CheckDecorator decorator;
        private final DiffRecordAccess recordAccess;
        private final long totalMappedMemory;
        private final StoreAccess storeAccess;
        private final InconsistencyReport report;

        Factory(CheckDecorator decorator, long totalMappedMemory, StoreAccess storeAccess, DiffRecordAccess recordAccess, InconsistencyReport report) {
            this.decorator = decorator;
            this.totalMappedMemory = totalMappedMemory;
            this.storeAccess = storeAccess;
            this.recordAccess = recordAccess;
            this.report = report;
        }

        StoreProcessor[] createAll(MultiPassStore ... stores) {
            ArrayList<StoreProcessor> result = new ArrayList<StoreProcessor>();
            for (MultiPassStore store : stores) {
                List<DiffRecordAccess> filters = store.multiPassFilters(this.totalMappedMemory, this.storeAccess, this.recordAccess, stores);
                for (DiffRecordAccess filter : filters) {
                    result.add(new StoreProcessor(this.decorator, new ConsistencyReporter(filter, this.report)));
                }
            }
            return result.toArray(new StoreProcessor[result.size()]);
        }
    }
}

