/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.SchemaRecordCheck;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.OwnerCheck;
import org.neo4j.consistency.checking.full.SchemaStoreProcessorTask;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.StoreProcessorTask;
import org.neo4j.consistency.checking.full.TaskExecutionOrder;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.store.CacheSmallStoresRecordAccess;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.util.StringLogger;

public class FullCheck {
    private final boolean checkPropertyOwners;
    private final TaskExecutionOrder order;
    private final ProgressMonitorFactory progressFactory;
    private final Long totalMappedMemory;

    public FullCheck(Config tuningConfiguration, ProgressMonitorFactory progressFactory) {
        this.checkPropertyOwners = (Boolean)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_property_owners);
        this.order = (TaskExecutionOrder)((Object)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_execution_order));
        this.totalMappedMemory = (Long)tuningConfiguration.get(GraphDatabaseSettings.all_stores_total_mapped_memory_size);
        this.progressFactory = progressFactory;
    }

    public ConsistencySummaryStatistics execute(StoreAccess store, StringLogger logger) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary = new ConsistencySummaryStatistics();
        InconsistencyReport report = new InconsistencyReport(new InconsistencyMessageLogger(logger), summary);
        OwnerCheck ownerCheck = new OwnerCheck(this.checkPropertyOwners, new DynamicStore[0]);
        this.execute(store, ownerCheck, FullCheck.recordAccess(store), report);
        ownerCheck.scanForOrphanChains(this.progressFactory);
        if (!summary.isConsistent()) {
            logger.logMessage("Inconsistencies found: " + summary);
        }
        return summary;
    }

    void execute(StoreAccess store, CheckDecorator decorator, DiffRecordAccess recordAccess, InconsistencyReport report) throws ConsistencyCheckIncompleteException {
        StoreProcessor processEverything = new StoreProcessor(decorator, new ConsistencyReporter(recordAccess, report));
        ProgressMonitorFactory.MultiPartBuilder progress = this.progressFactory.multipleParts("Full consistency check");
        ArrayList<StoreProcessorTask> tasks = new ArrayList<StoreProcessorTask>(16);
        MultiPassStore.Factory processorFactory = new MultiPassStore.Factory(decorator, this.totalMappedMemory, store, recordAccess, report);
        tasks.add(new StoreProcessorTask(store.getNodeStore(), progress, this.order, processEverything, processorFactory.createAll(MultiPassStore.PROPERTIES, MultiPassStore.RELATIONSHIPS)));
        tasks.add(new StoreProcessorTask(store.getRelationshipStore(), progress, this.order, processEverything, processorFactory.createAll(MultiPassStore.NODES, MultiPassStore.PROPERTIES, MultiPassStore.RELATIONSHIPS)));
        tasks.add(new StoreProcessorTask(store.getPropertyStore(), progress, this.order, processEverything, processorFactory.createAll(MultiPassStore.PROPERTIES, MultiPassStore.STRINGS, MultiPassStore.ARRAYS)));
        tasks.add(new StoreProcessorTask(store.getStringStore(), progress, this.order, processEverything, processorFactory.createAll(MultiPassStore.STRINGS)));
        tasks.add(new StoreProcessorTask(store.getArrayStore(), progress, this.order, processEverything, processorFactory.createAll(MultiPassStore.ARRAYS)));
        tasks.add(new StoreProcessorTask(store.getSchemaStore(), progress, this.order, processEverything, processEverything));
        SchemaRecordCheck schemaCheck = new SchemaRecordCheck((SchemaRuleAccess)((SchemaStore)store.getSchemaStore()));
        tasks.add(new SchemaStoreProcessorTask(store.getSchemaStore(), "check_rules", schemaCheck, progress, this.order, processEverything, processEverything));
        tasks.add(new SchemaStoreProcessorTask(store.getSchemaStore(), "check_obligations", schemaCheck.forObligationChecking(), progress, this.order, processEverything, processEverything));
        tasks.add(new StoreProcessorTask(store.getRelationshipTypeTokenStore(), progress, this.order, processEverything, processEverything));
        tasks.add(new StoreProcessorTask(store.getPropertyKeyTokenStore(), progress, this.order, processEverything, processEverything));
        tasks.add(new StoreProcessorTask(store.getLabelTokenStore(), progress, this.order, processEverything, processEverything));
        tasks.add(new StoreProcessorTask(store.getRelationshipTypeNameStore(), progress, this.order, processEverything, processEverything));
        tasks.add(new StoreProcessorTask(store.getPropertyKeyNameStore(), progress, this.order, processEverything, processEverything));
        tasks.add(new StoreProcessorTask(store.getLabelNameStore(), progress, this.order, processEverything, processEverything));
        tasks.add(new StoreProcessorTask(store.getNodeDynamicLabelStore(), progress, this.order, processEverything, processEverything));
        this.order.execute(tasks, progress.build());
    }

    static DiffRecordAccess recordAccess(StoreAccess store) {
        return new CacheSmallStoresRecordAccess(new DirectRecordAccess(store), (PropertyKeyTokenRecord[])FullCheck.readAllRecords(PropertyKeyTokenRecord.class, (RecordStore)store.getPropertyKeyTokenStore()), (RelationshipTypeTokenRecord[])FullCheck.readAllRecords(RelationshipTypeTokenRecord.class, (RecordStore)store.getRelationshipTypeTokenStore()), (LabelTokenRecord[])FullCheck.readAllRecords(LabelTokenRecord.class, (RecordStore)store.getLabelTokenStore()));
    }

    private static <T extends AbstractBaseRecord> T[] readAllRecords(Class<T> type, RecordStore<T> store) {
        AbstractBaseRecord[] records = (AbstractBaseRecord[])Array.newInstance(type, (int)store.getHighId());
        for (int i = 0; i < records.length; ++i) {
            records[i] = store.forceGetRecord((long)i);
        }
        return records;
    }
}

