/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.NodeField;
import org.neo4j.consistency.checking.PrimitiveRecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;

class RelationshipRecordCheck
extends PrimitiveRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> {
    RelationshipRecordCheck() {
        super(RelationshipTypeField.RELATIONSHIP_TYPE, NodeField.SOURCE, RelationshipField.SOURCE_PREV, RelationshipField.SOURCE_NEXT, NodeField.TARGET, RelationshipField.TARGET_PREV, RelationshipField.TARGET_NEXT);
    }

    private static enum RelationshipField implements RecordField<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>,
    ComparativeRecordChecker<RelationshipRecord, RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>
    {
        SOURCE_PREV(NodeField.SOURCE, Record.NO_PREV_RELATIONSHIP){

            @Override
            public long valueFrom(RelationshipRecord relationship) {
                return relationship.getFirstPrevRel();
            }

            @Override
            long other(NodeField field, RelationshipRecord relationship) {
                return field.next(relationship);
            }

            @Override
            void otherNode(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.sourcePrevReferencesOtherNodes(relationship);
            }

            @Override
            void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.sourcePrevDoesNotReferenceBack(relationship);
            }

            @Override
            void notUpdated(ConsistencyReport.RelationshipConsistencyReport report) {
                report.sourcePrevNotUpdated();
            }
        }
        ,
        SOURCE_NEXT(NodeField.SOURCE, Record.NO_NEXT_RELATIONSHIP){

            @Override
            public long valueFrom(RelationshipRecord relationship) {
                return relationship.getFirstNextRel();
            }

            @Override
            long other(NodeField field, RelationshipRecord relationship) {
                return field.prev(relationship);
            }

            @Override
            void otherNode(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.sourceNextReferencesOtherNodes(relationship);
            }

            @Override
            void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.sourceNextDoesNotReferenceBack(relationship);
            }

            @Override
            void notUpdated(ConsistencyReport.RelationshipConsistencyReport report) {
                report.sourceNextNotUpdated();
            }
        }
        ,
        TARGET_PREV(NodeField.TARGET, Record.NO_PREV_RELATIONSHIP){

            @Override
            public long valueFrom(RelationshipRecord relationship) {
                return relationship.getSecondPrevRel();
            }

            @Override
            long other(NodeField field, RelationshipRecord relationship) {
                return field.next(relationship);
            }

            @Override
            void otherNode(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.targetPrevReferencesOtherNodes(relationship);
            }

            @Override
            void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.targetPrevDoesNotReferenceBack(relationship);
            }

            @Override
            void notUpdated(ConsistencyReport.RelationshipConsistencyReport report) {
                report.targetPrevNotUpdated();
            }
        }
        ,
        TARGET_NEXT(NodeField.TARGET, Record.NO_NEXT_RELATIONSHIP){

            @Override
            public long valueFrom(RelationshipRecord relationship) {
                return relationship.getSecondNextRel();
            }

            @Override
            long other(NodeField field, RelationshipRecord relationship) {
                return field.prev(relationship);
            }

            @Override
            void otherNode(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.targetNextReferencesOtherNodes(relationship);
            }

            @Override
            void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.targetNextDoesNotReferenceBack(relationship);
            }

            @Override
            void notUpdated(ConsistencyReport.RelationshipConsistencyReport report) {
                report.targetNextNotUpdated();
            }
        };

        private final NodeField NODE;
        private final Record NONE;

        private RelationshipField(NodeField node, Record none) {
            this.NODE = node;
            this.NONE = none;
        }

        @Override
        public void checkConsistency(RelationshipRecord relationship, ConsistencyReport.RelationshipConsistencyReport report, RecordAccess records) {
            if (!this.NONE.is(this.valueFrom(relationship))) {
                report.forReference(records.relationship(this.valueFrom(relationship)), this);
            }
        }

        @Override
        public void checkReference(RelationshipRecord record, RelationshipRecord referred, ConsistencyReport.RelationshipConsistencyReport report, RecordAccess records) {
            NodeField field = NodeField.select(referred, this.node(record));
            if (field == null) {
                this.otherNode(report, referred);
            } else if (this.other(field, referred) != record.getId()) {
                this.noBackReference(report, referred);
            }
        }

        @Override
        public void checkChange(RelationshipRecord oldRecord, RelationshipRecord newRecord, ConsistencyReport.RelationshipConsistencyReport report, DiffRecordAccess records) {
            if (!(newRecord.inUse() && this.valueFrom(oldRecord) == this.valueFrom(newRecord) || this.NONE.is(this.valueFrom(oldRecord)) || records.changedRelationship(this.valueFrom(oldRecord)) != null)) {
                this.notUpdated(report);
            }
        }

        abstract void notUpdated(ConsistencyReport.RelationshipConsistencyReport var1);

        abstract long other(NodeField var1, RelationshipRecord var2);

        abstract void otherNode(ConsistencyReport.RelationshipConsistencyReport var1, RelationshipRecord var2);

        abstract void noBackReference(ConsistencyReport.RelationshipConsistencyReport var1, RelationshipRecord var2);

        private long node(RelationshipRecord relationship) {
            return this.NODE.valueFrom(relationship);
        }
    }

    private static enum RelationshipTypeField implements RecordField<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>,
    ComparativeRecordChecker<RelationshipRecord, RelationshipTypeTokenRecord, ConsistencyReport.RelationshipConsistencyReport>
    {
        RELATIONSHIP_TYPE;


        @Override
        public void checkConsistency(RelationshipRecord record, ConsistencyReport.RelationshipConsistencyReport report, RecordAccess records) {
            if (record.getType() < 0) {
                report.illegalRelationshipType();
            } else {
                report.forReference(records.relationshipType(record.getType()), this);
            }
        }

        @Override
        public long valueFrom(RelationshipRecord record) {
            return record.getType();
        }

        @Override
        public void checkChange(RelationshipRecord oldRecord, RelationshipRecord newRecord, ConsistencyReport.RelationshipConsistencyReport report, DiffRecordAccess records) {
        }

        @Override
        public void checkReference(RelationshipRecord record, RelationshipTypeTokenRecord referred, ConsistencyReport.RelationshipConsistencyReport report, RecordAccess records) {
            if (!referred.inUse()) {
                report.relationshipTypeNotInUse(referred);
            }
        }
    }
}

