/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.SchemaRuleContent;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;

public class SchemaRecordCheck
implements RecordCheck<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> {
    final SchemaRuleAccess ruleAccess;
    final Map<Long, DynamicRecord> indexObligations;
    final Map<Long, DynamicRecord> constraintObligations;
    final Map<SchemaRuleContent, DynamicRecord> contentMap;
    final Phase phase;
    public static final ComparativeRecordChecker<DynamicRecord, LabelTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_LABEL = new ComparativeRecordChecker<DynamicRecord, LabelTokenRecord, ConsistencyReport.SchemaConsistencyReport>(){

        @Override
        public void checkReference(DynamicRecord record, LabelTokenRecord labelTokenRecord, ConsistencyReport.SchemaConsistencyReport report, RecordAccess records) {
            if (!labelTokenRecord.inUse()) {
                report.labelNotInUse(labelTokenRecord);
            }
        }
    };
    public static final ComparativeRecordChecker<DynamicRecord, PropertyKeyTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_PROPERTY_KEY = new ComparativeRecordChecker<DynamicRecord, PropertyKeyTokenRecord, ConsistencyReport.SchemaConsistencyReport>(){

        @Override
        public void checkReference(DynamicRecord record, PropertyKeyTokenRecord propertyKeyTokenRecord, ConsistencyReport.SchemaConsistencyReport report, RecordAccess records) {
            if (!propertyKeyTokenRecord.inUse()) {
                report.propertyKeyNotInUse(propertyKeyTokenRecord);
            }
        }
    };

    private SchemaRecordCheck(SchemaRuleAccess ruleAccess, Map<Long, DynamicRecord> indexObligations, Map<Long, DynamicRecord> constraintObligations, Map<SchemaRuleContent, DynamicRecord> contentMap, Phase phase) {
        this.ruleAccess = ruleAccess;
        this.indexObligations = indexObligations;
        this.constraintObligations = constraintObligations;
        this.contentMap = contentMap;
        this.phase = phase;
    }

    public SchemaRecordCheck(SchemaRuleAccess ruleAccess) {
        this(ruleAccess, new HashMap<Long, DynamicRecord>(), new HashMap<Long, DynamicRecord>(), new HashMap<SchemaRuleContent, DynamicRecord>(), Phase.CHECK_RULES);
    }

    public SchemaRecordCheck forObligationChecking() {
        return new SchemaRecordCheck(this.ruleAccess, this.indexObligations, this.constraintObligations, this.contentMap, Phase.CHECK_OBLIGATIONS);
    }

    @Override
    public void check(DynamicRecord record, ConsistencyReport.SchemaConsistencyReport report, RecordAccess records) {
        if (record.inUse() && record.isStartRecord()) {
            SchemaRule rule;
            try {
                rule = this.ruleAccess.loadSingleSchemaRule(record.getId());
            }
            catch (MalformedSchemaRuleException e) {
                report.malformedSchemaRule();
                return;
            }
            if (Phase.CHECK_RULES == this.phase) {
                report.forReference(records.label((int)rule.getLabel()), VALID_LABEL);
                SchemaRuleContent content = new SchemaRuleContent(rule);
                DynamicRecord previousContentRecord = this.contentMap.put(content, record);
                if (null != previousContentRecord) {
                    report.duplicateRuleContent(previousContentRecord);
                }
            }
            SchemaRule.Kind kind = rule.getKind();
            switch (kind) {
                case INDEX_RULE: 
                case CONSTRAINT_INDEX_RULE: {
                    this.checkIndexRule((IndexRule)rule, record, records, report);
                    break;
                }
                case UNIQUENESS_CONSTRAINT: {
                    this.checkUniquenessConstraintRule((UniquenessConstraintRule)rule, record, records, report);
                    break;
                }
                default: {
                    report.unsupportedSchemaRuleKind(kind);
                }
            }
        }
    }

    private void checkUniquenessConstraintRule(UniquenessConstraintRule rule, DynamicRecord record, RecordAccess records, ConsistencyReport.SchemaConsistencyReport report) {
        if (this.phase == Phase.CHECK_RULES) {
            report.forReference(records.propertyKey((int)rule.getPropertyKey()), VALID_PROPERTY_KEY);
            DynamicRecord previousObligation = this.indexObligations.put(rule.getOwnedIndex(), record);
            if (null != previousObligation) {
                report.duplicateObligation(previousObligation);
            }
        } else if (this.phase == Phase.CHECK_OBLIGATIONS) {
            DynamicRecord obligation = this.constraintObligations.get(rule.getId());
            if (null == obligation) {
                report.missingObligation(SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
            } else if (obligation.getId() != rule.getOwnedIndex()) {
                report.uniquenessConstraintNotReferencingBack(obligation);
            }
        }
    }

    private void checkIndexRule(IndexRule rule, DynamicRecord record, RecordAccess records, ConsistencyReport.SchemaConsistencyReport report) {
        if (this.phase == Phase.CHECK_RULES) {
            DynamicRecord previousObligation;
            report.forReference(records.propertyKey((int)rule.getPropertyKey()), VALID_PROPERTY_KEY);
            if (rule.isConstraintIndex() && rule.getOwningConstraint() != null && null != (previousObligation = this.constraintObligations.put(rule.getOwningConstraint(), record))) {
                report.duplicateObligation(previousObligation);
            }
        } else if (this.phase == Phase.CHECK_OBLIGATIONS && rule.isConstraintIndex()) {
            DynamicRecord obligation = this.indexObligations.get(rule.getId());
            if (null == obligation) {
                if (rule.getOwningConstraint() != null) {
                    report.missingObligation(SchemaRule.Kind.UNIQUENESS_CONSTRAINT);
                }
            } else if (obligation.getId() != rule.getOwningConstraint().longValue()) {
                report.constraintIndexRuleNotReferencingBack(obligation);
            }
        }
    }

    @Override
    public void checkChange(DynamicRecord oldRecord, DynamicRecord newRecord, ConsistencyReport.SchemaConsistencyReport report, DiffRecordAccess records) {
    }

    static enum Phase {
        CHECK_RULES,
        CHECK_OBLIGATIONS;

    }
}

