/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.NodeField;
import org.neo4j.consistency.checking.PrimitiveRecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.labels.DynamicNodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;

class NodeRecordCheck
extends PrimitiveRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
    NodeRecordCheck() {
        super(RelationshipField.NEXT_REL, LabelsField.LABELS);
    }

    private static enum LabelsField implements RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport>,
    ComparativeRecordChecker<NodeRecord, LabelTokenRecord, ConsistencyReport.NodeConsistencyReport>
    {
        LABELS{

            @Override
            public void checkConsistency(NodeRecord node, ConsistencyReport.NodeConsistencyReport report, RecordAccess records) {
                NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
                if (nodeLabels instanceof DynamicNodeLabels) {
                    DynamicNodeLabels dynamicNodeLabels = (DynamicNodeLabels)nodeLabels;
                    long firstRecordId = dynamicNodeLabels.getFirstDynamicRecordId();
                    RecordReference<DynamicRecord> firstRecordReference = records.nodeLabels(firstRecordId);
                    report.forReference(firstRecordReference, new NodeLabelsComparativeRecordChecker());
                } else {
                    this.validateLabelIds(nodeLabels.get(null), report, records);
                }
            }

            private void validateLabelIds(long[] labelIds, ConsistencyReport.NodeConsistencyReport report, RecordAccess records) {
                for (long labelId : labelIds) {
                    report.forReference(records.label((int)labelId), this);
                }
                Arrays.sort(labelIds);
                for (int i = 1; i < labelIds.length; ++i) {
                    if (labelIds[i - 1] != labelIds[i]) continue;
                    report.labelDuplicate(labelIds[i]);
                }
            }

            @Override
            public void checkReference(NodeRecord node, LabelTokenRecord labelTokenRecord, ConsistencyReport.NodeConsistencyReport report, RecordAccess records) {
                if (!labelTokenRecord.inUse()) {
                    report.labelNotInUse(labelTokenRecord);
                }
            }

            @Override
            public void checkChange(NodeRecord oldRecord, NodeRecord newRecord, ConsistencyReport.NodeConsistencyReport report, DiffRecordAccess records) {
            }

            @Override
            public long valueFrom(NodeRecord record) {
                return record.getLabelField();
            }

            class NodeLabelsComparativeRecordChecker
            implements ComparativeRecordChecker<NodeRecord, DynamicRecord, ConsistencyReport.NodeConsistencyReport> {
                private HashMap<Long, DynamicRecord> recordIds = new HashMap();
                private List<DynamicRecord> recordList = new ArrayList<DynamicRecord>();
                private boolean allInUse = true;

                NodeLabelsComparativeRecordChecker() {
                }

                @Override
                public void checkReference(NodeRecord record, DynamicRecord dynamicRecord, ConsistencyReport.NodeConsistencyReport report, RecordAccess records) {
                    long nextBlock;
                    this.recordIds.put(dynamicRecord.getId(), dynamicRecord);
                    if (dynamicRecord.inUse()) {
                        if (this.allInUse) {
                            this.recordList.add(dynamicRecord);
                        }
                    } else {
                        this.allInUse = false;
                        report.dynamicLabelRecordNotInUse(dynamicRecord);
                    }
                    if (Record.NO_NEXT_BLOCK.is(nextBlock = dynamicRecord.getNextBlock())) {
                        if (this.allInUse) {
                            this.validateLabelIds(this.labelIds(this.recordList), report, records);
                        }
                    } else if (this.recordIds.containsKey(nextBlock)) {
                        report.dynamicRecordChainCycle(this.recordIds.get(nextBlock));
                    } else {
                        report.forReference(records.nodeLabels(nextBlock), this);
                    }
                }

                private long[] labelIds(List<DynamicRecord> recordList) {
                    long[] idArray = (long[])DynamicArrayStore.getRightArray((Pair)AbstractDynamicStore.readFullByteArrayFromHeavyRecords(recordList, (PropertyType)PropertyType.ARRAY));
                    return Arrays.copyOfRange(idArray, 1, idArray.length);
                }
            }
        };

    }

    private static enum RelationshipField implements RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport>,
    ComparativeRecordChecker<NodeRecord, RelationshipRecord, ConsistencyReport.NodeConsistencyReport>
    {
        NEXT_REL{

            @Override
            public void checkConsistency(NodeRecord node, ConsistencyReport.NodeConsistencyReport report, RecordAccess records) {
                if (!Record.NO_NEXT_RELATIONSHIP.is(node.getNextRel())) {
                    report.forReference(records.relationship(node.getNextRel()), this);
                }
            }

            @Override
            public void checkReference(NodeRecord node, RelationshipRecord relationship, ConsistencyReport.NodeConsistencyReport report, RecordAccess records) {
                if (!relationship.inUse()) {
                    report.relationshipNotInUse(relationship);
                } else {
                    NodeField selectedField = NodeField.select(relationship, node);
                    if (selectedField == null) {
                        report.relationshipForOtherNode(relationship);
                    } else {
                        NodeField[] fields = relationship.getFirstNode() == relationship.getSecondNode() ? NodeField.values() : new NodeField[]{selectedField};
                        for (NodeField field : fields) {
                            if (Record.NO_NEXT_RELATIONSHIP.is(field.prev(relationship))) continue;
                            field.notFirstInChain(report, relationship);
                        }
                    }
                }
            }

            @Override
            public void checkChange(NodeRecord oldRecord, NodeRecord newRecord, ConsistencyReport.NodeConsistencyReport report, DiffRecordAccess records) {
                if (!(newRecord.inUse() && this.valueFrom(oldRecord) == this.valueFrom(newRecord) || Record.NO_NEXT_RELATIONSHIP.is(this.valueFrom(oldRecord)) || records.changedRelationship(this.valueFrom(oldRecord)) != null)) {
                    report.relationshipNotUpdated();
                }
            }

            @Override
            public long valueFrom(NodeRecord record) {
                return record.getNextRel();
            }
        };

    }
}

