/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;

public class NodeDynamicLabelOrphanChainStartCheck
implements RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport>,
ComparativeRecordChecker<DynamicRecord, DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> {
    private static final ComparativeRecordChecker<DynamicRecord, NodeRecord, ConsistencyReport.DynamicLabelConsistencyReport> VALID_NODE_RECORD = new ComparativeRecordChecker<DynamicRecord, NodeRecord, ConsistencyReport.DynamicLabelConsistencyReport>(){

        @Override
        public void checkReference(DynamicRecord record, NodeRecord nodeRecord, ConsistencyReport.DynamicLabelConsistencyReport report, RecordAccess records) {
            if (!nodeRecord.inUse()) {
                report.orphanDynamicLabelRecordDueToInvalidOwner(nodeRecord);
            } else {
                Long dynamicLabelRecordId = NodeLabelsField.fieldDynamicLabelRecordId((long)nodeRecord.getLabelField());
                long recordId = record.getLongId();
                if (dynamicLabelRecordId == null || dynamicLabelRecordId != recordId) {
                    report.orphanDynamicLabelRecordDueToInvalidOwner(nodeRecord);
                }
            }
        }
    };

    @Override
    public void check(DynamicRecord record, ConsistencyReport.DynamicLabelConsistencyReport report, RecordAccess records) {
        if (record.inUse() && record.isStartRecord()) {
            Long ownerId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)record);
            if (null == ownerId) {
                report.orphanDynamicLabelRecord();
            } else {
                report.forReference(records.node(ownerId), VALID_NODE_RECORD);
            }
        }
    }

    @Override
    public void checkChange(DynamicRecord oldRecord, DynamicRecord newRecord, ConsistencyReport.DynamicLabelConsistencyReport report, DiffRecordAccess records) {
        this.check(newRecord, report, (RecordAccess)records);
    }

    @Override
    public void checkReference(DynamicRecord record, DynamicRecord record2, ConsistencyReport.DynamicLabelConsistencyReport report, RecordAccess records) {
    }
}

