/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;

public class SchemaRuleContent {
    private final SchemaRule schemaRule;

    public SchemaRuleContent(SchemaRule schemaRule) {
        this.schemaRule = schemaRule;
    }

    public String toString() {
        return "ContentOf:" + this.schemaRule.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SchemaRuleContent) {
            SchemaRuleContent that = (SchemaRuleContent)obj;
            if (this.schemaRule.getLabel() != that.schemaRule.getLabel()) {
                return false;
            }
            switch (this.schemaRule.getKind()) {
                case INDEX_RULE: 
                case CONSTRAINT_INDEX_RULE: {
                    if (!that.schemaRule.getKind().isIndex()) {
                        return false;
                    }
                    return SchemaRuleContent.indexRulesEquals((IndexRule)this.schemaRule, (IndexRule)that.schemaRule);
                }
                case UNIQUENESS_CONSTRAINT: {
                    return this.schemaRule.getKind() == that.schemaRule.getKind() && SchemaRuleContent.uniquenessConstraintEquals((UniquenessConstraintRule)this.schemaRule, (UniquenessConstraintRule)that.schemaRule);
                }
            }
            throw new IllegalArgumentException("Invalid SchemaRule kind: " + this.schemaRule.getKind());
        }
        return false;
    }

    private static boolean indexRulesEquals(IndexRule lhs, IndexRule rhs) {
        return lhs.getPropertyKey() == rhs.getPropertyKey();
    }

    private static boolean uniquenessConstraintEquals(UniquenessConstraintRule lhs, UniquenessConstraintRule rhs) {
        return lhs.getPropertyKey() == rhs.getPropertyKey();
    }

    public int hashCode() {
        return (int)this.schemaRule.getLabel();
    }
}

