/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.TokenRecord;

public interface ConsistencyReport<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport<RECORD, REPORT>> {
    public <REFERRED extends AbstractBaseRecord> void forReference(RecordReference<REFERRED> var1, ComparativeRecordChecker<RECORD, ? super REFERRED, REPORT> var2);

    public static interface DynamicConsistencyReport
    extends ConsistencyReport<DynamicRecord, DynamicConsistencyReport> {
        @Documented(value="The next block is not in use. ")
        public void nextNotInUse(DynamicRecord var1);

        @Documented(value="The record is not full, but references a next block. ")
        @Warning
        public void recordNotFullReferencesNext();

        @Documented(value="The length of the block is invalid. ")
        public void invalidLength();

        @Documented(value="The block is empty. ")
        @Warning
        public void emptyBlock();

        @Documented(value="The next block is empty. ")
        @Warning
        public void emptyNextBlock(DynamicRecord var1);

        @Documented(value="The next block references this (the same) record. ")
        public void selfReferentialNext();

        @Documented(value="The next block reference was changed, but the previously referenced block was not updated. ")
        public void nextNotUpdated();

        @Documented(value="The next block of this record is also referenced by another dynamic record. ")
        public void nextMultipleOwners(DynamicRecord var1);

        @Documented(value="The next block of this record is also referenced by a property record. ")
        public void nextMultipleOwners(PropertyRecord var1);

        @Documented(value="The next block of this record is also referenced by a relationship label. ")
        public void nextMultipleOwners(RelationshipTypeTokenRecord var1);

        @Documented(value="The next block of this record is also referenced by a property key. ")
        public void nextMultipleOwners(PropertyKeyTokenRecord var1);

        @Documented(value="This record not referenced from any other dynamic block, or from any property or name record. ")
        public void orphanDynamicRecord();
    }

    public static interface PropertyKeyConsistencyReport
    extends NameConsistencyReport<PropertyKeyTokenRecord, PropertyKeyConsistencyReport> {
        @Documented(value="The string record referred from this key is also referred from a another key. ")
        public void nameMultipleOwners(PropertyKeyTokenRecord var1);
    }

    public static interface LabelNameConsistencyReport
    extends NameConsistencyReport<LabelTokenRecord, LabelNameConsistencyReport> {
        @Documented(value="The string record referred from this label name is also referred from a another label name. ")
        public void nameMultipleOwners(LabelTokenRecord var1);
    }

    public static interface RelationshipTypeConsistencyReport
    extends NameConsistencyReport<RelationshipTypeTokenRecord, RelationshipTypeConsistencyReport> {
        @Documented(value="The string record referred from this relationship type is also referred from a another relationship type. ")
        public void nameMultipleOwners(RelationshipTypeTokenRecord var1);
    }

    public static interface NameConsistencyReport<RECORD extends TokenRecord, REPORT extends NameConsistencyReport<RECORD, REPORT>>
    extends ConsistencyReport<RECORD, REPORT> {
        @Documented(value="The name block is not in use. ")
        public void nameBlockNotInUse(DynamicRecord var1);

        @Documented(value="The name is empty. ")
        @Warning
        public void emptyName(DynamicRecord var1);

        @Documented(value="The string record referred from this name record is also referred from a another string record. ")
        public void nameMultipleOwners(DynamicRecord var1);
    }

    public static interface PropertyConsistencyReport
    extends ConsistencyReport<PropertyRecord, PropertyConsistencyReport> {
        @Documented(value="The property key as an invalid value. ")
        public void invalidPropertyKey(PropertyBlock var1);

        @Documented(value="The key for this property is not in use. ")
        public void keyNotInUse(PropertyBlock var1, PropertyKeyTokenRecord var2);

        @Documented(value="The previous property record is not in use. ")
        public void prevNotInUse(PropertyRecord var1);

        @Documented(value="The next property record is not in use. ")
        public void nextNotInUse(PropertyRecord var1);

        @Documented(value="The previous property record does not have this record as its next record. ")
        public void previousDoesNotReferenceBack(PropertyRecord var1);

        @Documented(value="The next property record does not have this record as its previous record. ")
        public void nextDoesNotReferenceBack(PropertyRecord var1);

        @Documented(value="The type of this property is invalid. ")
        public void invalidPropertyType(PropertyBlock var1);

        @Documented(value="The string block is not in use. ")
        public void stringNotInUse(PropertyBlock var1, DynamicRecord var2);

        @Documented(value="The array block is not in use. ")
        public void arrayNotInUse(PropertyBlock var1, DynamicRecord var2);

        @Documented(value="The string block is empty. ")
        public void stringEmpty(PropertyBlock var1, DynamicRecord var2);

        @Documented(value="The array block is empty. ")
        public void arrayEmpty(PropertyBlock var1, DynamicRecord var2);

        @Documented(value="The property value is invalid. ")
        public void invalidPropertyValue(PropertyBlock var1);

        @Documented(value="This record is first in a property chain, but no Node or Relationship records reference this record. ")
        public void orphanPropertyChain();

        @Documented(value="The previous reference has changed, but the referenced record has not been updated. ")
        public void prevNotUpdated();

        @Documented(value="The next reference has changed, but the referenced record has not been updated. ")
        public void nextNotUpdated();

        @Documented(value="The string property is not referenced anymore, but the corresponding block has not been deleted. ")
        public void stringUnreferencedButNotDeleted(PropertyBlock var1);

        @Documented(value="The array property is not referenced anymore, but the corresponding block as not been deleted. ")
        public void arrayUnreferencedButNotDeleted(PropertyBlock var1);

        @Documented(value=" This property was declared to be changed for a node or relationship, but that node or relationship does not\n contain this property in its property chain.\n")
        public void ownerDoesNotReferenceBack();

        @Documented(value=" This property was declared to be changed for a node or relationship, but that node or relationship did not\n contain this property in its property chain prior to the change. The property is referenced by another owner.\n")
        public void changedForWrongOwner();

        @Documented(value="The string record referred from this property is also referred from a another property. ")
        public void stringMultipleOwners(PropertyRecord var1);

        @Documented(value="The array record referred from this property is also referred from a another property. ")
        public void arrayMultipleOwners(PropertyRecord var1);

        @Documented(value="The string record referred from this property is also referred from a another string record. ")
        public void stringMultipleOwners(DynamicRecord var1);

        @Documented(value="The array record referred from this property is also referred from a another array record. ")
        public void arrayMultipleOwners(DynamicRecord var1);
    }

    public static interface RelationshipConsistencyReport
    extends PrimitiveConsistencyReport<RelationshipRecord, RelationshipConsistencyReport> {
        @Documented(value="The label field has an illegal value. ")
        public void illegalLabel();

        @Documented(value="The label record is not in use. ")
        public void labelNotInUse(RelationshipTypeTokenRecord var1);

        @Documented(value="The source node field has an illegal value. ")
        public void illegalSourceNode();

        @Documented(value="The target node field has an illegal value. ")
        public void illegalTargetNode();

        @Documented(value="The source node is not in use. ")
        public void sourceNodeNotInUse(NodeRecord var1);

        @Documented(value="The target node is not in use. ")
        public void targetNodeNotInUse(NodeRecord var1);

        @Documented(value="This record should be the first in the source chain, but the source node does not reference this record. ")
        public void sourceNodeDoesNotReferenceBack(NodeRecord var1);

        @Documented(value="This record should be the first in the target chain, but the target node does not reference this record. ")
        public void targetNodeDoesNotReferenceBack(NodeRecord var1);

        @Documented(value="The source node does not have a relationship chain. ")
        public void sourceNodeHasNoRelationships(NodeRecord var1);

        @Documented(value="The target node does not have a relationship chain. ")
        public void targetNodeHasNoRelationships(NodeRecord var1);

        @Documented(value="The previous record in the source chain is a relationship between two other nodes. ")
        public void sourcePrevReferencesOtherNodes(RelationshipRecord var1);

        @Documented(value="The next record in the source chain is a relationship between two other nodes. ")
        public void sourceNextReferencesOtherNodes(RelationshipRecord var1);

        @Documented(value="The previous record in the target chain is a relationship between two other nodes. ")
        public void targetPrevReferencesOtherNodes(RelationshipRecord var1);

        @Documented(value="The next record in the target chain is a relationship between two other nodes. ")
        public void targetNextReferencesOtherNodes(RelationshipRecord var1);

        @Documented(value="The previous record in the source chain does not have this record as its next record. ")
        public void sourcePrevDoesNotReferenceBack(RelationshipRecord var1);

        @Documented(value="The next record in the source chain does not have this record as its previous record. ")
        public void sourceNextDoesNotReferenceBack(RelationshipRecord var1);

        @Documented(value="The previous record in the target chain does not have this record as its next record. ")
        public void targetPrevDoesNotReferenceBack(RelationshipRecord var1);

        @Documented(value="The next record in the target chain does not have this record as its previous record. ")
        public void targetNextDoesNotReferenceBack(RelationshipRecord var1);

        @Documented(value="The previous source relationship reference has changed, but the previously referenced record has not been updated. ")
        public void sourcePrevNotUpdated();

        @Documented(value="The next source relationship reference has changed, but the previously referenced record has not been updated. ")
        public void sourceNextNotUpdated();

        @Documented(value="The previous target relationship reference has changed, but the previously referenced record has not been updated. ")
        public void targetPrevNotUpdated();

        @Documented(value="The next target relationship reference has changed, but the previously referenced record has not been updated. ")
        public void targetNextNotUpdated();

        @Documented(value=" This relationship was first in the chain for the source node, and isn't first anymore,\n but the source node was not updated.\n")
        public void sourceNodeNotUpdated();

        @Documented(value=" This relationship was first in the chain for the target node, and isn't first anymore,\n but the target node was not updated.\n")
        public void targetNodeNotUpdated();
    }

    public static interface NodeConsistencyReport
    extends PrimitiveConsistencyReport<NodeRecord, NodeConsistencyReport> {
        @Documented(value="The referenced relationship record is not in use. ")
        public void relationshipNotInUse(RelationshipRecord var1);

        @Documented(value="The referenced relationship record is a relationship between two other nodes. ")
        public void relationshipForOtherNode(RelationshipRecord var1);

        @Documented(value="The referenced relationship record is not the first in the relationship chain where this node is source. ")
        public void relationshipNotFirstInSourceChain(RelationshipRecord var1);

        @Documented(value="The referenced relationship record is not the first in the relationship chain where this node is target. ")
        public void relationshipNotFirstInTargetChain(RelationshipRecord var1);

        @Documented(value="The first relationship record reference has changed, but the previous first relationship record has not been updates. ")
        public void relationshipNotUpdated();
    }

    public static interface NeoStoreConsistencyReport
    extends PrimitiveConsistencyReport<NeoStoreRecord, NeoStoreConsistencyReport> {
    }

    public static interface PrimitiveConsistencyReport<RECORD extends PrimitiveRecord, REPORT extends PrimitiveConsistencyReport<RECORD, REPORT>>
    extends ConsistencyReport<RECORD, REPORT> {
        @Documented(value="The referenced property record is not in use. ")
        public void propertyNotInUse(PropertyRecord var1);

        @Documented(value="The referenced property record is not the first in its property chain. ")
        public void propertyNotFirstInChain(PropertyRecord var1);

        @Documented(value="The referenced property is owned by another Node. ")
        public void multipleOwners(NodeRecord var1);

        @Documented(value="The referenced property is owned by another Relationship. ")
        public void multipleOwners(RelationshipRecord var1);

        @Documented(value="The referenced property is owned by the neo store (graph global property). ")
        public void multipleOwners(NeoStoreRecord var1);

        @Documented(value="The first property record reference has changed, but the previous first property record has not been updated. ")
        public void propertyNotUpdated();
    }

    public static interface Reporter {
        public void forNode(NodeRecord var1, RecordCheck<NodeRecord, NodeConsistencyReport> var2);

        public void forNodeChange(NodeRecord var1, NodeRecord var2, RecordCheck<NodeRecord, NodeConsistencyReport> var3);

        public void forRelationship(RelationshipRecord var1, RecordCheck<RelationshipRecord, RelationshipConsistencyReport> var2);

        public void forRelationshipChange(RelationshipRecord var1, RelationshipRecord var2, RecordCheck<RelationshipRecord, RelationshipConsistencyReport> var3);

        public void forProperty(PropertyRecord var1, RecordCheck<PropertyRecord, PropertyConsistencyReport> var2);

        public void forPropertyChange(PropertyRecord var1, PropertyRecord var2, RecordCheck<PropertyRecord, PropertyConsistencyReport> var3);

        public void forRelationshipTypeName(RelationshipTypeTokenRecord var1, RecordCheck<RelationshipTypeTokenRecord, RelationshipTypeConsistencyReport> var2);

        public void forRelationshipTypeNameChange(RelationshipTypeTokenRecord var1, RelationshipTypeTokenRecord var2, RecordCheck<RelationshipTypeTokenRecord, RelationshipTypeConsistencyReport> var3);

        public void forLabelName(LabelTokenRecord var1, RecordCheck<LabelTokenRecord, LabelNameConsistencyReport> var2);

        public void forLabelNameChange(LabelTokenRecord var1, LabelTokenRecord var2, RecordCheck<LabelTokenRecord, LabelNameConsistencyReport> var3);

        public void forPropertyKey(PropertyKeyTokenRecord var1, RecordCheck<PropertyKeyTokenRecord, PropertyKeyConsistencyReport> var2);

        public void forPropertyKeyChange(PropertyKeyTokenRecord var1, PropertyKeyTokenRecord var2, RecordCheck<PropertyKeyTokenRecord, PropertyKeyConsistencyReport> var3);

        public void forDynamicBlock(RecordType var1, DynamicRecord var2, RecordCheck<DynamicRecord, DynamicConsistencyReport> var3);

        public void forDynamicBlockChange(RecordType var1, DynamicRecord var2, DynamicRecord var3, RecordCheck<DynamicRecord, DynamicConsistencyReport> var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.METHOD})
    public static @interface IncrementalOnly {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Warning {
    }
}

