/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.incremental.intercept;

import java.io.File;
import org.neo4j.consistency.ConsistencyCheckingError;
import org.neo4j.consistency.checking.InconsistentStoreException;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.incremental.DiffCheck;
import org.neo4j.consistency.store.DiffStore;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.util.StringLogger;

class CheckingTransactionInterceptor
implements TransactionInterceptor {
    private TransactionInterceptor next;
    private LogEntry.Start startEntry;
    private LogEntry.Commit commitEntry;
    private final DiffStore diffs;
    private final DiffCheck checker;
    private final StringLogger diffLog;

    CheckingTransactionInterceptor(DiffCheck checker, NeoStoreXaDataSource dataSource, StringLogger logger, String log) {
        StringLogger diffLog = null;
        if (log != null) {
            diffLog = "true".equalsIgnoreCase(log) ? logger : StringLogger.logger((File)new File(log));
        }
        this.checker = checker;
        this.diffLog = diffLog;
        this.diffs = new DiffStore(dataSource.getNeoStore());
    }

    void setNext(TransactionInterceptor next) {
        this.next = next;
    }

    public void setStartEntry(LogEntry.Start startEntry) {
        this.startEntry = startEntry;
        if (this.next != null) {
            this.next.setStartEntry(startEntry);
        }
    }

    public void setCommitEntry(LogEntry.Commit commitEntry) {
        this.commitEntry = commitEntry;
        if (this.next != null) {
            this.next.setCommitEntry(commitEntry);
        }
    }

    public void visitNode(NodeRecord record) {
        this.diffs.visitNode(record);
        if (this.next != null) {
            this.next.visitNode(record);
        }
    }

    public void visitRelationship(RelationshipRecord record) {
        this.diffs.visitRelationship(record);
        if (this.next != null) {
            this.next.visitRelationship(record);
        }
    }

    public void visitProperty(PropertyRecord record) {
        this.diffs.visitProperty(record);
        if (this.next != null) {
            this.next.visitProperty(record);
        }
    }

    public void visitRelationshipTypeToken(RelationshipTypeTokenRecord record) {
        this.diffs.visitRelationshipTypeToken(record);
        if (this.next != null) {
            this.next.visitRelationshipTypeToken(record);
        }
    }

    public void visitLabelToken(LabelTokenRecord record) {
        this.diffs.visitLabelToken(record);
        if (this.next != null) {
            this.next.visitLabelToken(record);
        }
    }

    public void visitPropertyKeyToken(PropertyKeyTokenRecord record) {
        this.diffs.visitPropertyKeyToken(record);
        if (this.next != null) {
            this.next.visitPropertyKeyToken(record);
        }
    }

    public void visitNeoStore(NeoStoreRecord record) {
        this.diffs.visitNeoStore(record);
        if (this.next != null) {
            this.next.visitNeoStore(record);
        }
    }

    public void complete() throws ConsistencyCheckingError {
        try {
            this.checker.check(this.diffs);
        }
        catch (InconsistentStoreException inconsistency) {
            throw new ConsistencyCheckingError(this.startEntry, this.commitEntry, inconsistency.summary());
        }
        catch (ConsistencyCheckIncompleteException e) {
            e.printStackTrace();
        }
    }
}

