/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.incremental;

import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.incremental.DiffCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DiffStore;
import org.neo4j.kernel.impl.util.StringLogger;

public class LoggingDiffCheck
extends DiffCheck {
    private final DiffCheck checker;

    public LoggingDiffCheck(DiffCheck checker, StringLogger logger) {
        super(logger);
        this.checker = checker;
    }

    @Override
    public ConsistencySummaryStatistics execute(DiffStore diffs) throws ConsistencyCheckIncompleteException {
        return this.checker.execute(diffs);
    }

    @Override
    protected void verify(DiffStore diffs, ConsistencySummaryStatistics summary) {
        if (!summary.isConsistent()) {
            this.logger.logMessage("Inconsistencies found: " + summary);
        }
    }
}

