/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.AbstractStoreProcessor;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;

class StoreProcessor
extends AbstractStoreProcessor {
    private final ConsistencyReport.Reporter report;

    public StoreProcessor(CheckDecorator decorator, ConsistencyReport.Reporter report) {
        super(decorator);
        this.report = report;
    }

    @Override
    protected void checkNode(RecordStore<NodeRecord> store, NodeRecord node, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.report.forNode(node, checker);
    }

    @Override
    protected void checkRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        this.report.forRelationship(rel, checker);
    }

    @Override
    protected void checkProperty(RecordStore<PropertyRecord> store, PropertyRecord property, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.report.forProperty(property, checker);
    }

    @Override
    protected void checkRelationshipTypeName(RecordStore<RelationshipTypeTokenRecord> store, RelationshipTypeTokenRecord relationshipType, RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
        this.report.forRelationshipTypeName(relationshipType, checker);
    }

    @Override
    protected void checkLabelName(RecordStore<LabelTokenRecord> store, LabelTokenRecord label, RecordCheck<LabelTokenRecord, ConsistencyReport.LabelNameConsistencyReport> checker) {
        this.report.forLabelName(label, checker);
    }

    @Override
    protected void checkPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> store, PropertyKeyTokenRecord key, RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyConsistencyReport> checker) {
        this.report.forPropertyKey(key, checker);
    }

    @Override
    protected void checkDynamic(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord string, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.report.forDynamicBlock(type, string, checker);
    }
}

