/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.full.Owner;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.TokenRecord;

abstract class DynamicOwner<RECORD extends AbstractBaseRecord>
implements Owner {
    static final ComparativeRecordChecker<DynamicRecord, AbstractBaseRecord, ConsistencyReport.DynamicConsistencyReport> ORPHAN_CHECK = new ComparativeRecordChecker<DynamicRecord, AbstractBaseRecord, ConsistencyReport.DynamicConsistencyReport>(){

        @Override
        public void checkReference(DynamicRecord record, AbstractBaseRecord ignored, ConsistencyReport.DynamicConsistencyReport report, RecordAccess records) {
            report.orphanDynamicRecord();
        }
    };

    abstract RecordReference<RECORD> record(RecordAccess var1);

    @Override
    public void checkOrphanage() {
    }

    private DynamicOwner() {
    }

    static class Unknown
    extends DynamicOwner<AbstractBaseRecord>
    implements RecordReference<AbstractBaseRecord> {
        private PendingReferenceCheck<AbstractBaseRecord> reporter;

        Unknown() {
        }

        @Override
        RecordReference<AbstractBaseRecord> record(RecordAccess records) {
            this.markInCustody();
            return RecordReference.SkippingReference.skipReference();
        }

        @Override
        public void checkOrphanage() {
            PendingReferenceCheck<AbstractBaseRecord> reporter = this.pop();
            if (reporter != null) {
                reporter.checkReference(null, null);
            }
        }

        void markInCustody() {
            PendingReferenceCheck<AbstractBaseRecord> reporter = this.pop();
            if (reporter != null) {
                reporter.skip();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized PendingReferenceCheck<AbstractBaseRecord> pop() {
            try {
                PendingReferenceCheck<AbstractBaseRecord> pendingReferenceCheck = this.reporter;
                return pendingReferenceCheck;
            }
            finally {
                this.reporter = null;
            }
        }

        @Override
        public synchronized void dispatch(PendingReferenceCheck<AbstractBaseRecord> reporter) {
            this.reporter = reporter;
        }
    }

    static class RelationshipTypeToken
    extends NameOwner<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> {
        private final int id;

        RelationshipTypeToken(RelationshipTypeTokenRecord record) {
            this.id = record.getId();
        }

        @Override
        RecordReference<RelationshipTypeTokenRecord> record(RecordAccess records) {
            return records.relationshipType(this.id);
        }
    }

    static class LabelToken
    extends NameOwner<LabelTokenRecord, ConsistencyReport.LabelNameConsistencyReport> {
        private final int id;

        LabelToken(LabelTokenRecord record) {
            this.id = record.getId();
        }

        @Override
        RecordReference<LabelTokenRecord> record(RecordAccess records) {
            return records.label(this.id);
        }
    }

    static class PropertyKey
    extends NameOwner<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyConsistencyReport> {
        private final int id;

        PropertyKey(PropertyKeyTokenRecord record) {
            this.id = record.getId();
        }

        @Override
        RecordReference<PropertyKeyTokenRecord> record(RecordAccess records) {
            return records.propertyKey(this.id);
        }
    }

    static abstract class NameOwner<RECORD extends TokenRecord, REPORT extends ConsistencyReport.NameConsistencyReport<RECORD, REPORT>>
    extends DynamicOwner<RECORD>
    implements ComparativeRecordChecker<RECORD, AbstractBaseRecord, REPORT> {
        NameOwner() {
        }

        @Override
        public void checkReference(RECORD name, AbstractBaseRecord record, REPORT genericReport, RecordAccess records) {
            REPORT report = genericReport;
            if (record instanceof RelationshipTypeTokenRecord) {
                ((ConsistencyReport.RelationshipTypeConsistencyReport)report).nameMultipleOwners((RelationshipTypeTokenRecord)record);
            } else if (record instanceof PropertyKeyTokenRecord) {
                ((ConsistencyReport.PropertyKeyConsistencyReport)report).nameMultipleOwners((PropertyKeyTokenRecord)record);
            } else if (record instanceof DynamicRecord) {
                report.nameMultipleOwners((DynamicRecord)record);
            }
        }
    }

    static class Dynamic
    extends DynamicOwner<DynamicRecord>
    implements ComparativeRecordChecker<DynamicRecord, AbstractBaseRecord, ConsistencyReport.DynamicConsistencyReport> {
        private final long id;
        private final RecordType type;

        Dynamic(RecordType type, DynamicRecord record) {
            this.type = type;
            this.id = record.getId();
        }

        @Override
        RecordReference<DynamicRecord> record(RecordAccess records) {
            switch (this.type) {
                case STRING_PROPERTY: {
                    return records.string(this.id);
                }
                case ARRAY_PROPERTY: {
                    return records.array(this.id);
                }
                case PROPERTY_KEY_NAME: {
                    return records.propertyKeyName((int)this.id);
                }
                case RELATIONSHIP_LABEL_NAME: {
                    return records.relationshipTypeName((int)this.id);
                }
            }
            return RecordReference.SkippingReference.skipReference();
        }

        @Override
        public void checkReference(DynamicRecord block, AbstractBaseRecord record, ConsistencyReport.DynamicConsistencyReport report, RecordAccess records) {
            if (record instanceof PropertyRecord) {
                report.nextMultipleOwners((PropertyRecord)record);
            } else if (record instanceof DynamicRecord) {
                report.nextMultipleOwners((DynamicRecord)record);
            } else if (record instanceof RelationshipTypeTokenRecord) {
                report.nextMultipleOwners((RelationshipTypeTokenRecord)record);
            } else if (record instanceof PropertyKeyTokenRecord) {
                report.nextMultipleOwners((PropertyKeyTokenRecord)record);
            }
        }
    }

    static class Property
    extends DynamicOwner<PropertyRecord>
    implements ComparativeRecordChecker<PropertyRecord, AbstractBaseRecord, ConsistencyReport.PropertyConsistencyReport> {
        private final long id;
        private final RecordType type;

        Property(RecordType type, PropertyRecord record) {
            this.type = type;
            this.id = record.getId();
        }

        @Override
        RecordReference<PropertyRecord> record(RecordAccess records) {
            return records.property(this.id);
        }

        @Override
        public void checkReference(PropertyRecord property, AbstractBaseRecord record, ConsistencyReport.PropertyConsistencyReport report, RecordAccess records) {
            if (record instanceof PropertyRecord) {
                if (this.type == RecordType.STRING_PROPERTY) {
                    report.stringMultipleOwners((PropertyRecord)record);
                } else {
                    report.arrayMultipleOwners((PropertyRecord)record);
                }
            } else if (record instanceof DynamicRecord) {
                if (this.type == RecordType.STRING_PROPERTY) {
                    report.stringMultipleOwners((DynamicRecord)record);
                } else {
                    report.arrayMultipleOwners((DynamicRecord)record);
                }
            }
        }
    }
}

