/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.DynamicRecordCheck;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.LabelTokenRecordCheck;
import org.neo4j.consistency.checking.NeoStoreCheck;
import org.neo4j.consistency.checking.NodeRecordCheck;
import org.neo4j.consistency.checking.PropertyKeyTokenRecordCheck;
import org.neo4j.consistency.checking.PropertyRecordCheck;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.RelationshipRecordCheck;
import org.neo4j.consistency.checking.RelationshipTypeTokenRecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;

public abstract class AbstractStoreProcessor
extends RecordStore.Processor<RuntimeException> {
    private final RecordCheck<NeoStoreRecord, ConsistencyReport.NeoStoreConsistencyReport> neoStoreChecker;
    private final RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> nodeChecker;
    private final RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> relationshipChecker;
    private final RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> propertyChecker;
    private final RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyConsistencyReport> propertyKeyTokenChecker;
    private final RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> relationshipTypeTokenChecker;
    private final RecordCheck<LabelTokenRecord, ConsistencyReport.LabelNameConsistencyReport> labelTokenChecker;

    public AbstractStoreProcessor() {
        this(CheckDecorator.NONE);
    }

    public AbstractStoreProcessor(CheckDecorator decorator) {
        this.neoStoreChecker = decorator.decorateNeoStoreChecker(new NeoStoreCheck());
        this.nodeChecker = decorator.decorateNodeChecker(new NodeRecordCheck());
        this.relationshipChecker = decorator.decorateRelationshipChecker(new RelationshipRecordCheck());
        this.propertyChecker = decorator.decoratePropertyChecker(new PropertyRecordCheck());
        this.propertyKeyTokenChecker = decorator.decoratePropertyKeyTokenChecker(new PropertyKeyTokenRecordCheck());
        this.relationshipTypeTokenChecker = decorator.decorateRelationshipTypeTokenChecker(new RelationshipTypeTokenRecordCheck());
        this.labelTokenChecker = decorator.decorateLabelTokenChecker(new LabelTokenRecordCheck());
    }

    protected abstract void checkNode(RecordStore<NodeRecord> var1, NodeRecord var2, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> var3);

    protected abstract void checkRelationship(RecordStore<RelationshipRecord> var1, RelationshipRecord var2, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> var3);

    protected abstract void checkProperty(RecordStore<PropertyRecord> var1, PropertyRecord var2, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> var3);

    protected abstract void checkRelationshipTypeName(RecordStore<RelationshipTypeTokenRecord> var1, RelationshipTypeTokenRecord var2, RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> var3);

    protected abstract void checkLabelName(RecordStore<LabelTokenRecord> var1, LabelTokenRecord var2, RecordCheck<LabelTokenRecord, ConsistencyReport.LabelNameConsistencyReport> var3);

    protected abstract void checkPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> var1, PropertyKeyTokenRecord var2, RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyConsistencyReport> var3);

    protected abstract void checkDynamic(RecordType var1, RecordStore<DynamicRecord> var2, DynamicRecord var3, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> var4);

    public final void processNode(RecordStore<NodeRecord> store, NodeRecord node) {
        this.checkNode(store, node, this.nodeChecker);
    }

    public final void processRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel) {
        this.checkRelationship(store, rel, this.relationshipChecker);
    }

    public final void processProperty(RecordStore<PropertyRecord> store, PropertyRecord property) {
        this.checkProperty(store, property, this.propertyChecker);
    }

    public final void processString(RecordStore<DynamicRecord> store, DynamicRecord string, IdType idType) {
        DynamicStore dereference;
        RecordType type;
        switch (idType) {
            case STRING_BLOCK: {
                type = RecordType.STRING_PROPERTY;
                dereference = DynamicStore.STRING;
                break;
            }
            case RELATIONSHIP_TYPE_TOKEN_NAME: {
                type = RecordType.RELATIONSHIP_LABEL_NAME;
                dereference = DynamicStore.RELATIONSHIP_LABEL;
                break;
            }
            case PROPERTY_KEY_TOKEN_NAME: {
                type = RecordType.PROPERTY_KEY_NAME;
                dereference = DynamicStore.PROPERTY_KEY;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The id type [%s] is not valid for String records.", idType));
            }
        }
        this.checkDynamic(type, store, string, new DynamicRecordCheck(store, dereference));
    }

    public final void processArray(RecordStore<DynamicRecord> store, DynamicRecord array) {
        this.checkDynamic(RecordType.ARRAY_PROPERTY, store, array, new DynamicRecordCheck(store, DynamicStore.ARRAY));
    }

    public final void processRelationshipType(RecordStore<RelationshipTypeTokenRecord> store, RelationshipTypeTokenRecord record) {
        this.checkRelationshipTypeName(store, record, this.relationshipTypeTokenChecker);
    }

    public final void processPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> store, PropertyKeyTokenRecord record) {
        this.checkPropertyKeyToken(store, record, this.propertyKeyTokenChecker);
    }

    public void processLabelName(RecordStore<LabelTokenRecord> store, LabelTokenRecord record) {
        this.checkLabelName(store, record, this.labelTokenChecker);
    }
}

