/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.AbstractNameRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;

abstract class NameRecordCheck<RECORD extends AbstractNameRecord, REPORT extends ConsistencyReport<RECORD, REPORT>>
implements RecordCheck<RECORD, REPORT>,
ComparativeRecordChecker<RECORD, DynamicRecord, REPORT> {
    NameRecordCheck() {
    }

    @Override
    public void checkChange(RECORD oldRecord, RECORD newRecord, REPORT report, DiffRecordAccess records) {
        this.check(newRecord, report, (RecordAccess)records);
    }

    @Override
    public void check(RECORD record, REPORT report, RecordAccess records) {
        if (!record.inUse()) {
            return;
        }
        if (!Record.NO_NEXT_BLOCK.is((long)record.getNameId())) {
            report.forReference(this.name(records, record.getNameId()), this);
        }
    }

    @Override
    public void checkReference(RECORD record, DynamicRecord name, REPORT report, RecordAccess records) {
        if (!name.inUse()) {
            this.nameNotInUse(report, name);
        } else if (name.getLength() <= 0) {
            this.emptyName(report, name);
        }
    }

    abstract RecordReference<DynamicRecord> name(RecordAccess var1, int var2);

    abstract void nameNotInUse(REPORT var1, DynamicRecord var2);

    abstract void emptyName(REPORT var1, DynamicRecord var2);
}

