/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;

public class PendingReferenceCheck<REFERENCED extends AbstractBaseRecord> {
    private ConsistencyReport report;
    private final ComparativeRecordChecker checker;

    PendingReferenceCheck(ConsistencyReport report, ComparativeRecordChecker checker) {
        this.report = report;
        this.checker = checker;
    }

    public synchronized String toString() {
        if (this.report == null) {
            return String.format("CompletedReferenceCheck{%s}", this.checker);
        }
        return ConsistencyReporter.pendingCheckToString(this.report, this.checker);
    }

    public void checkReference(REFERENCED referenced, RecordAccess records) {
        ConsistencyReporter.dispatchReference(this.report(), this.checker, referenced, records);
    }

    public void checkDiffReference(REFERENCED oldReferenced, REFERENCED newReferenced, RecordAccess records) {
        ConsistencyReporter.dispatchChangeReference(this.report(), this.checker, oldReferenced, newReferenced, records);
    }

    public synchronized void skip() {
        if (this.report != null) {
            ConsistencyReporter.dispatchSkip(this.report);
            this.report = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ConsistencyReport report() {
        if (this.report == null) {
            throw new IllegalStateException("Reference has already been checked.");
        }
        try {
            ConsistencyReport consistencyReport = this.report;
            return consistencyReport;
        }
        finally {
            this.report = null;
        }
    }
}

