/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;

public class CacheSmallStoresRecordAccess
implements DiffRecordAccess {
    private final DiffRecordAccess delegate;
    private final PropertyIndexRecord[] propertyRecords;
    private final RelationshipTypeRecord[] relationshipLabels;

    public CacheSmallStoresRecordAccess(DiffRecordAccess delegate, PropertyIndexRecord[] propertyRecords, RelationshipTypeRecord[] relationshipLabels) {
        this.delegate = delegate;
        this.propertyRecords = propertyRecords;
        this.relationshipLabels = relationshipLabels;
    }

    @Override
    public RecordReference<NodeRecord> node(long id) {
        return this.delegate.node(id);
    }

    @Override
    public RecordReference<RelationshipRecord> relationship(long id) {
        return this.delegate.relationship(id);
    }

    @Override
    public RecordReference<PropertyRecord> property(long id) {
        return this.delegate.property(id);
    }

    @Override
    public RecordReference<RelationshipTypeRecord> relationshipLabel(int id) {
        if (id < this.relationshipLabels.length) {
            return new DirectRecordReference<RelationshipTypeRecord>(this.relationshipLabels[id], this);
        }
        return this.delegate.relationshipLabel(id);
    }

    @Override
    public RecordReference<PropertyIndexRecord> propertyKey(int id) {
        if (id < this.propertyRecords.length) {
            return new DirectRecordReference<PropertyIndexRecord>(this.propertyRecords[id], this);
        }
        return this.delegate.propertyKey(id);
    }

    @Override
    public RecordReference<DynamicRecord> string(long id) {
        return this.delegate.string(id);
    }

    @Override
    public RecordReference<DynamicRecord> array(long id) {
        return this.delegate.array(id);
    }

    @Override
    public RecordReference<DynamicRecord> relationshipLabelName(int id) {
        return this.delegate.relationshipLabelName(id);
    }

    @Override
    public RecordReference<DynamicRecord> propertyKeyName(int id) {
        return this.delegate.propertyKeyName(id);
    }

    @Override
    public RecordReference<NeoStoreRecord> graph() {
        return this.delegate.graph();
    }

    @Override
    public RecordReference<NodeRecord> previousNode(long id) {
        return this.delegate.previousNode(id);
    }

    @Override
    public RecordReference<RelationshipRecord> previousRelationship(long id) {
        return this.delegate.previousRelationship(id);
    }

    @Override
    public RecordReference<PropertyRecord> previousProperty(long id) {
        return this.delegate.previousProperty(id);
    }

    @Override
    public RecordReference<NeoStoreRecord> previousGraph() {
        return this.delegate.previousGraph();
    }

    @Override
    public NodeRecord changedNode(long id) {
        return this.delegate.changedNode(id);
    }

    @Override
    public RelationshipRecord changedRelationship(long id) {
        return this.delegate.changedRelationship(id);
    }

    @Override
    public PropertyRecord changedProperty(long id) {
        return this.delegate.changedProperty(id);
    }

    @Override
    public DynamicRecord changedString(long id) {
        return this.delegate.changedString(id);
    }

    @Override
    public DynamicRecord changedArray(long id) {
        return this.delegate.changedArray(id);
    }
}

