/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.old;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.neo4j.consistency.checking.old.InconsistencyReport;
import org.neo4j.consistency.checking.old.InconsistencyType;
import org.neo4j.consistency.checking.old.PropertyOwner;
import org.neo4j.consistency.repair.RelationshipChainField;
import org.neo4j.consistency.repair.RelationshipNodeField;
import org.neo4j.consistency.store.DiffRecordStore;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;

@Deprecated
public class ConsistencyRecordProcessor
extends RecordStore.Processor
implements Runnable {
    private final RecordStore<NodeRecord> nodes;
    private final RecordStore<RelationshipRecord> rels;
    private final RecordStore<PropertyRecord> props;
    private final RecordStore<DynamicRecord> strings;
    private final RecordStore<DynamicRecord> arrays;
    private final RecordStore<PropertyIndexRecord> propIndexes;
    private final RecordStore<RelationshipTypeRecord> relTypes;
    private final RecordStore<DynamicRecord> propKeys;
    private final RecordStore<DynamicRecord> typeNames;
    private final HashMap<Long, PropertyOwner> propertyOwners;
    private long brokenNodes;
    private long brokenRels;
    private long brokenProps;
    private long brokenStrings;
    private long brokenArrays;
    private long brokenTypes;
    private long brokenKeys;
    private final InconsistencyReport report;
    private static final RelationshipNodeField[] nodeFields = RelationshipNodeField.values();
    private static final RelationshipChainField[] relFields = RelationshipChainField.values();
    private final ProgressMonitorFactory progressFactory;

    public ConsistencyRecordProcessor(StoreAccess stores, InconsistencyReport report) {
        this(stores, false, report, ProgressMonitorFactory.NONE);
    }

    public ConsistencyRecordProcessor(StoreAccess stores, InconsistencyReport report, ProgressMonitorFactory progressFactory) {
        this(stores, false, report, progressFactory);
    }

    public ConsistencyRecordProcessor(StoreAccess stores, boolean checkPropertyOwners, InconsistencyReport report, ProgressMonitorFactory progressFactory) {
        this.nodes = stores.getNodeStore();
        this.rels = stores.getRelationshipStore();
        this.props = stores.getPropertyStore();
        this.strings = stores.getStringStore();
        this.arrays = stores.getArrayStore();
        this.relTypes = stores.getRelationshipTypeStore();
        this.propIndexes = stores.getPropertyIndexStore();
        this.propKeys = stores.getPropertyKeyStore();
        this.typeNames = stores.getTypeNameStore();
        this.propertyOwners = checkPropertyOwners ? new HashMap() : null;
        this.report = report;
        this.progressFactory = progressFactory;
    }

    public void processNode(RecordStore<NodeRecord> store, NodeRecord node) {
        if (this.checkNode(node)) {
            ++this.brokenNodes;
        }
    }

    public void processRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel) {
        if (this.checkRelationship(rel)) {
            ++this.brokenRels;
        }
    }

    public void processProperty(RecordStore<PropertyRecord> store, PropertyRecord property) {
        if (this.checkProperty(property)) {
            ++this.brokenProps;
        }
    }

    public void processString(RecordStore<DynamicRecord> store, DynamicRecord string, IdType idType) {
        if (this.checkDynamic(store, string)) {
            ++this.brokenStrings;
        }
    }

    public void processArray(RecordStore<DynamicRecord> store, DynamicRecord array) {
        if (this.checkDynamic(store, array)) {
            ++this.brokenArrays;
        }
    }

    public void processRelationshipType(RecordStore<RelationshipTypeRecord> store, RelationshipTypeRecord type) {
        if (this.checkType(type)) {
            ++this.brokenTypes;
        }
    }

    public void processPropertyIndex(RecordStore<PropertyIndexRecord> store, PropertyIndexRecord index) {
        if (this.checkKey(index)) {
            ++this.brokenKeys;
        }
    }

    private boolean checkNode(NodeRecord node) {
        boolean fail = false;
        if (!node.inUse()) {
            NodeRecord old = (NodeRecord)this.nodes.forceGetRaw((AbstractBaseRecord)node);
            if (old.inUse()) {
                RelationshipRecord rel;
                if (!Record.NO_NEXT_RELATIONSHIP.is(old.getNextRel()) && (rel = (RelationshipRecord)this.rels.forceGetRecord(old.getNextRel())).inUse()) {
                    fail |= this.report.inconsistent(this.nodes, node, this.rels, rel, InconsistencyType.ReferenceInconsistency.RELATIONSHIP_NOT_REMOVED_FOR_DELETED_NODE);
                }
                fail |= this.checkPropertyReference(node, this.nodes, new PropertyOwner.OwningNode(node.getId()));
            }
            return fail;
        }
        long relId = node.getNextRel();
        if (!Record.NO_NEXT_RELATIONSHIP.is(relId)) {
            RelationshipRecord rel = (RelationshipRecord)this.rels.forceGetRecord(relId);
            if (!rel.inUse()) {
                fail |= this.report.inconsistent(this.nodes, node, this.rels, rel, InconsistencyType.ReferenceInconsistency.RELATIONSHIP_NOT_IN_USE);
            } else if (rel.getFirstNode() != node.getId() && rel.getSecondNode() != node.getId()) {
                fail |= this.report.inconsistent(this.nodes, node, this.rels, rel, InconsistencyType.ReferenceInconsistency.RELATIONSHIP_FOR_OTHER_NODE);
            }
        }
        return fail |= this.checkPropertyReference(node, this.nodes, new PropertyOwner.OwningNode(node.getId()));
    }

    private <R extends PrimitiveRecord> boolean checkPropertyReference(R primitive, RecordStore<R> store, PropertyOwner owner) {
        boolean fail = false;
        if (this.props != null) {
            PropertyRecord prop;
            PrimitiveRecord old = (PrimitiveRecord)store.forceGetRaw(primitive);
            if (primitive.inUse()) {
                PropertyRecord oldProp;
                if (!Record.NO_NEXT_PROPERTY.is(primitive.getNextProp())) {
                    PropertyRecord prop2 = (PropertyRecord)this.props.forceGetRecord(primitive.getNextProp());
                    fail |= this.checkPropertyOwner(prop2, owner);
                    if (!prop2.inUse()) {
                        fail |= this.report.inconsistent(store, primitive, this.props, prop2, InconsistencyType.ReferenceInconsistency.PROPERTY_NOT_IN_USE);
                    } else if (owner.otherOwnerOf(prop2) != -1L || owner.ownerOf(prop2) != -1L && owner.ownerOf(prop2) != primitive.getId()) {
                        fail |= this.report.inconsistent(store, primitive, this.props, prop2, InconsistencyType.ReferenceInconsistency.PROPERTY_FOR_OTHER);
                    }
                }
                if (old.inUse() && old.getNextProp() != primitive.getNextProp() && !Record.NO_NEXT_PROPERTY.is(old.getNextProp()) && owner.ownerOf(oldProp = (PropertyRecord)this.props.forceGetRecord(old.getNextProp())) != primitive.getId()) {
                    fail |= this.report.inconsistent(this.props, oldProp, store, primitive, InconsistencyType.ReferenceInconsistency.ORPHANED_PROPERTY);
                }
            } else if (!Record.NO_NEXT_PROPERTY.is(old.getNextProp()) && (prop = (PropertyRecord)this.props.forceGetRecord(old.getNextProp())).inUse()) {
                fail |= this.report.inconsistent(store, primitive, this.props, prop, owner.propertyNotRemoved());
            }
        }
        return fail;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkRelationship(RelationshipRecord rel) {
        boolean fail = false;
        if (!rel.inUse()) {
            RelationshipRecord old = (RelationshipRecord)this.rels.forceGetRaw((AbstractBaseRecord)rel);
            if (old.inUse()) {
                void var6_10;
                RelationshipChainField[] arr$ = relFields;
                int len$ = arr$.length;
                boolean bl = false;
                while (var6_10 < len$) {
                    RelationshipChainField field = arr$[var6_10];
                    long otherId = field.relOf(old);
                    if (otherId == field.none) {
                        NodeRecord node;
                        Long nodeId = field.nodeOf(old);
                        if (nodeId != null && (node = (NodeRecord)this.nodes.forceGetRecord(nodeId.longValue())).inUse() && node.getNextRel() == old.getId()) {
                            fail |= this.report.inconsistent(this.rels, rel, this.nodes, node, InconsistencyType.ReferenceInconsistency.REMOVED_RELATIONSHIP_STILL_REFERENCED);
                        }
                    } else {
                        RelationshipRecord other = (RelationshipRecord)this.rels.forceGetRecord(otherId);
                        if (other.inUse() && field.invConsistent(old, other)) {
                            fail |= this.report.inconsistent(this.rels, rel, other, InconsistencyType.ReferenceInconsistency.REMOVED_RELATIONSHIP_STILL_REFERENCED);
                        }
                    }
                    ++var6_10;
                }
                fail |= this.checkPropertyReference(rel, this.rels, new PropertyOwner.OwningRelationship(rel.getId()));
            }
            return fail;
        }
        if (rel.getType() < 0) {
            fail |= this.report.inconsistent(this.rels, rel, InconsistencyType.ReferenceInconsistency.INVALID_TYPE_ID);
        } else {
            RelationshipTypeRecord type = (RelationshipTypeRecord)this.relTypes.forceGetRecord((long)rel.getType());
            if (!type.inUse()) {
                fail |= this.report.inconsistent(this.rels, rel, this.relTypes, type, InconsistencyType.ReferenceInconsistency.TYPE_NOT_IN_USE);
            }
        }
        for (RelationshipChainField relationshipChainField : relFields) {
            long otherId = relationshipChainField.relOf(rel);
            if (otherId == relationshipChainField.none) {
                NodeRecord node;
                Long nodeId = relationshipChainField.nodeOf(rel);
                if (nodeId == null || (node = (NodeRecord)this.nodes.forceGetRecord(nodeId.longValue())).inUse() && node.getNextRel() == rel.getId()) continue;
                fail |= this.report.inconsistent(this.rels, rel, this.nodes, node, relationshipChainField.noBackReference);
                continue;
            }
            RelationshipRecord other = (RelationshipRecord)this.rels.forceGetRecord(otherId);
            if (!other.inUse()) {
                fail |= this.report.inconsistent(this.rels, rel, other, relationshipChainField.notInUse);
                continue;
            }
            if (relationshipChainField.invConsistent(rel, other)) continue;
            fail |= this.report.inconsistent(this.rels, rel, other, relationshipChainField.differentChain);
        }
        for (Enum enum_ : nodeFields) {
            long nodeId = ((RelationshipNodeField)enum_).get(rel);
            if (nodeId < 0L) {
                fail |= this.report.inconsistent(this.rels, rel, ((RelationshipNodeField)enum_).invalidReference);
                continue;
            }
            NodeRecord node = (NodeRecord)this.nodes.forceGetRecord(nodeId);
            if (node.inUse()) continue;
            fail |= this.report.inconsistent(this.rels, rel, this.nodes, node, ((RelationshipNodeField)enum_).notInUse);
        }
        return fail |= this.checkPropertyReference(rel, this.rels, new PropertyOwner.OwningRelationship(rel.getId()));
    }

    private boolean checkPropertyOwner(PropertyRecord prop, PropertyOwner newOwner) {
        if (this.propertyOwners == null) {
            return false;
        }
        Long propId = prop.getId();
        PropertyOwner oldOwner = this.propertyOwners.put(propId, newOwner);
        if (oldOwner != null) {
            RecordStore<? extends PrimitiveRecord> oldStore = oldOwner.storeFrom(this.nodes, this.rels);
            RecordStore<? extends PrimitiveRecord> newStore = newOwner.storeFrom(this.nodes, this.rels);
            return this.report.inconsistent(oldStore, oldStore.getRecord(oldOwner.id), newStore, newStore.getRecord(newOwner.id), InconsistencyType.PropertyOwnerInconsistency.OwnerInconsistencyType.MULTIPLE_OWNERS.forProperty(prop));
        }
        return false;
    }

    private boolean checkProperty(PropertyRecord property) {
        long prevId;
        boolean fail = false;
        if (!property.inUse()) {
            PropertyRecord old = (PropertyRecord)this.props.forceGetRaw((AbstractBaseRecord)property);
            if (old.inUse()) {
                PropertyRecord next;
                if (!Record.NO_NEXT_PROPERTY.is(old.getNextProp()) && (next = (PropertyRecord)this.props.forceGetRecord(old.getNextProp())).inUse() && next.getPrevProp() == old.getId()) {
                    fail |= this.report.inconsistent(this.props, property, next, InconsistencyType.ReferenceInconsistency.REMOVED_PROPERTY_STILL_REFERENCED);
                }
                if (!Record.NO_PREVIOUS_PROPERTY.is(old.getPrevProp())) {
                    PropertyRecord prev = (PropertyRecord)this.props.forceGetRecord(old.getPrevProp());
                    if (prev.inUse() && prev.getNextProp() == old.getId()) {
                        fail |= this.report.inconsistent(this.props, property, prev, InconsistencyType.ReferenceInconsistency.REMOVED_PROPERTY_STILL_REFERENCED);
                    }
                } else if (property.getNodeId() != -1L) {
                    fail |= this.checkPropertyOwnerReference(property, property.getNodeId(), this.nodes);
                } else if (property.getRelId() != -1L) {
                    fail |= this.checkPropertyOwnerReference(property, property.getRelId(), this.rels);
                } else if (((DiffRecordStore)this.props).isModified(property.getId())) {
                    fail |= this.report.inconsistent(this.props, property, InconsistencyType.ReferenceInconsistency.PROPERTY_CHANGED_WITHOUT_OWNER);
                }
                fail |= this.checkOwnerChain(property);
            }
            return fail;
        }
        long nextId = property.getNextProp();
        if (!Record.NO_NEXT_PROPERTY.is(nextId)) {
            PropertyRecord next = (PropertyRecord)this.props.forceGetRecord(nextId);
            if (!next.inUse()) {
                fail |= this.report.inconsistent(this.props, property, next, InconsistencyType.ReferenceInconsistency.NEXT_PROPERTY_NOT_IN_USE);
            }
            if (next.getPrevProp() != property.getId()) {
                fail |= this.report.inconsistent(this.props, property, next, InconsistencyType.ReferenceInconsistency.PROPERTY_NEXT_WRONG_BACKREFERENCE);
            }
        }
        if (!Record.NO_PREVIOUS_PROPERTY.is(prevId = property.getPrevProp())) {
            PropertyRecord prev = (PropertyRecord)this.props.forceGetRecord(prevId);
            if (!prev.inUse()) {
                fail |= this.report.inconsistent(this.props, property, prev, InconsistencyType.ReferenceInconsistency.PREV_PROPERTY_NOT_IN_USE);
            }
            if (prev.getNextProp() != property.getId()) {
                fail |= this.report.inconsistent(this.props, property, prev, InconsistencyType.ReferenceInconsistency.PROPERTY_PREV_WRONG_BACKREFERENCE);
            }
        } else if (property.getNodeId() != -1L) {
            fail |= this.checkPropertyOwnerReference(property, property.getNodeId(), this.nodes);
        } else if (property.getRelId() != -1L) {
            fail |= this.checkPropertyOwnerReference(property, property.getRelId(), this.rels);
        } else if (this.props instanceof DiffRecordStore && ((DiffRecordStore)this.props).isModified(property.getId())) {
            fail |= this.report.inconsistent(this.props, property, InconsistencyType.ReferenceInconsistency.PROPERTY_CHANGED_WITHOUT_OWNER);
        }
        fail |= this.checkOwnerChain(property);
        for (PropertyBlock block : property.getPropertyBlocks()) {
            DynamicRecord dynrec;
            if (block.getKeyIndexId() < 0) {
                fail |= this.report.inconsistent(this.props, property, InconsistencyType.PropertyBlockInconsistency.BlockInconsistencyType.INVALID_PROPERTY_KEY.forBlock(block));
            } else {
                PropertyIndexRecord key = (PropertyIndexRecord)this.propIndexes.forceGetRecord((long)block.getKeyIndexId());
                if (!key.inUse()) {
                    fail |= this.report.inconsistent(this.props, property, this.propIndexes, key, InconsistencyType.PropertyBlockInconsistency.BlockInconsistencyType.UNUSED_PROPERTY_KEY.forBlock(block));
                }
            }
            RecordStore<DynamicRecord> dynStore = null;
            PropertyType type = block.forceGetType();
            if (type == null) {
                fail |= this.report.inconsistent(this.props, property, InconsistencyType.PropertyBlockInconsistency.BlockInconsistencyType.ILLEGAL_PROPERTY_TYPE.forBlock(block));
            } else {
                switch (block.getType()) {
                    case STRING: {
                        dynStore = this.strings;
                        break;
                    }
                    case ARRAY: {
                        dynStore = this.arrays;
                    }
                }
            }
            if (dynStore == null || (dynrec = (DynamicRecord)dynStore.forceGetRecord(block.getSingleValueLong())).inUse()) continue;
            fail |= this.report.inconsistent(this.props, property, dynStore, dynrec, InconsistencyType.PropertyBlockInconsistency.BlockInconsistencyType.DYNAMIC_NOT_IN_USE.forBlock(block));
        }
        return fail;
    }

    private boolean checkOwnerChain(PropertyRecord property) {
        boolean fail = false;
        RecordStore<NodeRecord> store = null;
        long ownerId = -1L;
        if (property.getNodeId() != -1L) {
            store = this.nodes;
            ownerId = property.getNodeId();
        } else if (property.getRelId() != -1L) {
            store = this.rels;
            ownerId = property.getRelId();
        }
        if (store != null) {
            PrimitiveRecord owner = (PrimitiveRecord)store.forceGetRecord(ownerId);
            if (!property.inUse()) {
                owner = (PrimitiveRecord)store.forceGetRaw((AbstractBaseRecord)owner);
            }
            ArrayList<PropertyRecord> chain = new ArrayList<PropertyRecord>(2);
            PropertyRecord prop = null;
            long propId = owner.getNextProp();
            long target = property.getId();
            while (propId != target) {
                if (Record.NO_NEXT_PROPERTY.is(propId)) {
                    fail |= this.report.inconsistent(this.props, property, store, owner, InconsistencyType.PropertyOwnerInconsistency.OwnerInconsistencyType.PROPERTY_CHANGED_FOR_WRONG_OWNER.forProperties(chain));
                    break;
                }
                prop = (PropertyRecord)this.props.forceGetRecord(propId);
                if (!property.inUse()) {
                    prop = (PropertyRecord)this.props.forceGetRaw((AbstractBaseRecord)prop);
                }
                chain.add(prop);
                propId = prop.getNextProp();
            }
        } else if (this.props instanceof DiffRecordStore && ((DiffRecordStore)this.props).isModified(property.getId())) {
            fail |= this.report.inconsistent(this.props, property, InconsistencyType.ReferenceInconsistency.PROPERTY_CHANGED_WITHOUT_OWNER);
        }
        return fail;
    }

    private boolean checkPropertyOwnerReference(PropertyRecord property, long ownerId, RecordStore<? extends PrimitiveRecord> entityStore) {
        PrimitiveRecord old;
        DiffRecordStore diffs;
        boolean fail = false;
        PrimitiveRecord entity = (PrimitiveRecord)entityStore.forceGetRecord(ownerId);
        if (!property.inUse()) {
            if (entity.inUse() && entity.getNextProp() == property.getId()) {
                fail |= this.report.inconsistent(this.props, property, entityStore, entity, InconsistencyType.ReferenceInconsistency.REMOVED_PROPERTY_STILL_REFERENCED);
            }
            return fail;
        }
        if (!entity.inUse()) {
            fail |= this.report.inconsistent(this.props, property, entityStore, entity, InconsistencyType.ReferenceInconsistency.OWNER_NOT_IN_USE);
        } else if (entity.getNextProp() != property.getId()) {
            fail |= this.report.inconsistent(this.props, property, entityStore, entity, InconsistencyType.ReferenceInconsistency.OWNER_DOES_NOT_REFERENCE_BACK);
        }
        if (entityStore instanceof DiffRecordStore && (diffs = (DiffRecordStore)entityStore).isModified(entity.getId()) && (old = diffs.forceGetRaw(entity)).inUse() && !Record.NO_NEXT_PROPERTY.is(old.getNextProp()) && old.getNextProp() != property.getId() && !((DiffRecordStore)this.props).isModified(old.getNextProp())) {
            fail |= this.report.inconsistent(this.props, property, entityStore, entity, InconsistencyType.ReferenceInconsistency.REPLACED_PROPERTY);
        }
        return fail;
    }

    private boolean checkDynamic(RecordStore<DynamicRecord> store, DynamicRecord record) {
        DynamicRecord prev;
        DiffRecordStore diffs;
        boolean fail = false;
        if (!record.inUse()) {
            DynamicRecord next;
            DynamicRecord old;
            if (store instanceof DiffRecordStore && (old = (DynamicRecord)store.forceGetRaw((AbstractBaseRecord)record)).inUse() && !Record.NO_NEXT_BLOCK.is(old.getNextBlock()) && (next = (DynamicRecord)store.forceGetRecord(old.getNextBlock())).inUse()) {
                fail |= this.report.inconsistent(store, record, next, InconsistencyType.ReferenceInconsistency.NEXT_DYNAMIC_NOT_REMOVED);
            }
            return fail;
        }
        long nextId = record.getNextBlock();
        if (!Record.NO_NEXT_BLOCK.is(nextId)) {
            DynamicRecord next = (DynamicRecord)store.forceGetRecord(nextId);
            if (!next.inUse()) {
                fail |= this.report.inconsistent(store, record, next, InconsistencyType.ReferenceInconsistency.NEXT_DYNAMIC_NOT_IN_USE);
            }
            if (record.getLength() < store.getRecordSize() - store.getRecordHeaderSize()) {
                fail |= this.report.inconsistent(store, record, InconsistencyType.ReferenceInconsistency.NON_FULL_DYNAMIC_WITH_NEXT);
            }
        }
        if (record.getId() != 0L && record.getLength() > store.getRecordSize() - store.getRecordHeaderSize()) {
            fail |= this.report.inconsistent(store, record, InconsistencyType.ReferenceInconsistency.DYNAMIC_LENGTH_TOO_LARGE);
        }
        if (store instanceof DiffRecordStore && (diffs = (DiffRecordStore)store).isModified(record.getId()) && !record.isLight() && (prev = diffs.forceGetRaw(record)).inUse()) {
            fail |= this.report.inconsistent(store, record, prev, InconsistencyType.ReferenceInconsistency.OVERWRITE_USED_DYNAMIC);
        }
        return fail;
    }

    private boolean checkType(RelationshipTypeRecord type) {
        if (!type.inUse()) {
            return false;
        }
        if (Record.NO_NEXT_BLOCK.is((long)type.getNameId())) {
            return false;
        }
        DynamicRecord record = (DynamicRecord)this.typeNames.forceGetRecord((long)type.getNameId());
        if (!record.inUse()) {
            return this.report.inconsistent(this.relTypes, type, this.typeNames, record, InconsistencyType.ReferenceInconsistency.UNUSED_TYPE_NAME);
        }
        return false;
    }

    private boolean checkKey(PropertyIndexRecord key) {
        if (!key.inUse()) {
            return false;
        }
        if (Record.NO_NEXT_BLOCK.is((long)key.getNameId())) {
            return false;
        }
        DynamicRecord record = (DynamicRecord)this.propKeys.forceGetRecord((long)key.getNameId());
        if (!record.inUse()) {
            return this.report.inconsistent(this.propIndexes, key, this.propKeys, record, InconsistencyType.ReferenceInconsistency.UNUSED_KEY_NAME);
        }
        return false;
    }

    @Override
    public void run() {
        ProgressMonitorFactory.MultiPartBuilder builder = this.progressFactory.multipleParts("ConsistencyCheck");
        ArrayList<StoreProcessor<Object>> tasks = new ArrayList<StoreProcessor<Object>>(9);
        tasks.add(this.storeProcessor(this.nodes, builder));
        tasks.add(this.storeProcessor(this.rels, builder));
        if (this.propertyOwners != null) {
            this.propertyOwners.clear();
        }
        tasks.add(this.storeProcessor(this.props, builder));
        if (this.propertyOwners != null) {
            this.propertyOwners.clear();
        }
        tasks.add(this.storeProcessor(this.strings, builder));
        tasks.add(this.storeProcessor(this.arrays, builder));
        tasks.add(this.storeProcessor(this.relTypes, builder));
        tasks.add(this.storeProcessor(this.propIndexes, builder));
        tasks.add(this.storeProcessor(this.propKeys, builder));
        tasks.add(this.storeProcessor(this.typeNames, builder));
        builder.build();
        for (Runnable runnable : tasks) {
            runnable.run();
        }
    }

    private <R extends AbstractBaseRecord> StoreProcessor<R> storeProcessor(RecordStore<R> store, ProgressMonitorFactory.MultiPartBuilder builder) {
        return new StoreProcessor(store, builder);
    }

    private class StoreProcessor<R extends AbstractBaseRecord>
    implements Runnable {
        private final RecordStore<R> store;
        private final ProgressListener progressListener;

        private StoreProcessor(RecordStore<R> store, ProgressMonitorFactory.MultiPartBuilder builder) {
            this.store = store;
            File name = store.getStorageFileName();
            this.progressListener = builder.progressForPart(name.getName(), store.getHighId());
        }

        @Override
        public void run() {
            ConsistencyRecordProcessor.this.applyFiltered(this.store, this.progressListener, new Predicate[]{RecordStore.IN_USE});
        }
    }
}

