/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store.paging;

import org.neo4j.consistency.store.paging.CachedPageList;
import org.neo4j.consistency.store.paging.Page;
import org.neo4j.consistency.store.paging.PageLoadFailureException;
import org.neo4j.consistency.store.paging.PageReplacementStrategy;
import org.neo4j.consistency.store.paging.TemporalUtility;
import org.neo4j.consistency.store.paging.TemporalUtilityCounter;

public class Cart
implements PageReplacementStrategy,
TemporalUtilityCounter {
    private final int capacity;
    private int p = 0;
    private int q = 0;
    private int shortTermUtilityPageCount = 0;
    private int longTermUtilityPageCount = 0;
    private CachedPageList recencyCache = new CachedPageList();
    private CachedPageList recencyHistory = new CachedPageList();
    private CachedPageList frequencyCache = new CachedPageList();
    private CachedPageList frequencyHistory = new CachedPageList();

    public Cart(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public <PAYLOAD, PAGE extends Page<PAYLOAD>> PAYLOAD acquire(PAGE page, PageReplacementStrategy.Storage<PAYLOAD, PAGE> storage) throws PageLoadFailureException {
        if (page.currentList == this.recencyCache || page.currentList == this.frequencyCache) {
            page.setReferenced();
            page.hit();
            return (PAYLOAD)page.payload;
        }
        if (this.recencyCache.size() + this.frequencyCache.size() == this.capacity) {
            this.replace();
            if (page.currentList != this.recencyHistory && page.currentList != this.frequencyHistory && this.recencyHistory.size() + this.frequencyHistory.size() == this.capacity + 1) {
                if (this.recencyHistory.size() > Cart.max(0, this.q) || this.frequencyHistory.size() == 0) {
                    this.recencyHistory.removeHead().setUtility(this, TemporalUtility.UNKNOWN);
                } else {
                    this.frequencyHistory.removeHead().setUtility(this, TemporalUtility.UNKNOWN);
                }
            }
        }
        if (page.currentList == this.recencyHistory) {
            this.p = Cart.min(this.p + Cart.max(1, this.shortTermUtilityPageCount / this.recencyHistory.size()), this.capacity);
            page.clearReference().moveToTailOf(this.recencyCache).setUtility(this, TemporalUtility.LONG_TERM);
        } else if (page.currentList == this.frequencyHistory) {
            this.p = Cart.max(this.p - Cart.max(1, this.longTermUtilityPageCount / this.frequencyHistory.size()), 0);
            page.clearReference().moveToTailOf(this.recencyCache).setUtility(this, TemporalUtility.LONG_TERM);
            if (this.frequencyCache.size() + this.frequencyHistory.size() + this.recencyCache.size() - this.shortTermUtilityPageCount >= this.capacity) {
                this.q = Cart.min(this.q + 1, 2 * this.capacity - this.recencyCache.size());
            }
        } else {
            page.moveToTailOf(this.recencyCache).setUtility(this, TemporalUtility.SHORT_TERM);
        }
        page.payload = storage.load(page);
        return (PAYLOAD)page.payload;
    }

    @Override
    public <PAYLOAD> void forceEvict(Page<PAYLOAD> page) {
        page.clearReference().setUtility(this, TemporalUtility.UNKNOWN).moveToTailOf(null).evict();
    }

    private void replace() {
        while (this.frequencyCache.size() > 0 && this.frequencyCache.head.referenced) {
            this.frequencyCache.head.clearReference().moveToTailOf(this.recencyCache);
            if (this.frequencyCache.size() + this.frequencyHistory.size() + this.recencyHistory.size() - this.shortTermUtilityPageCount < this.capacity) continue;
            this.q = Cart.min(this.q + 1, 2 * this.capacity - this.recencyCache.size());
        }
        while (this.recencyCache.size() > 0 && (this.recencyCache.head.utility == TemporalUtility.LONG_TERM || this.recencyCache.head.referenced)) {
            if (this.recencyCache.head.referenced) {
                Page page = this.recencyCache.head.clearReference().moveToTailOf(this.recencyCache);
                if (this.recencyCache.size() <= Cart.min(this.p + 1, this.recencyHistory.size()) || page.utility != TemporalUtility.SHORT_TERM) continue;
                page.setUtility(this, TemporalUtility.LONG_TERM);
                continue;
            }
            this.recencyCache.head.clearReference().moveToTailOf(this.frequencyCache);
            this.q = Cart.max(this.q - 1, this.capacity - this.recencyCache.size());
        }
        if (this.recencyCache.size() >= Cart.max(1, this.p)) {
            this.recencyCache.head.evict();
            this.recencyCache.head.moveToTailOf(this.recencyHistory).setUtility(this, TemporalUtility.LONG_TERM);
        } else {
            this.frequencyCache.head.evict();
            this.frequencyCache.head.moveToTailOf(this.frequencyHistory).setUtility(this, TemporalUtility.SHORT_TERM);
        }
    }

    private static int min(int i1, int i2) {
        return i1 < i2 ? i1 : i2;
    }

    private static int max(int i1, int i2) {
        return i1 > i2 ? i1 : i2;
    }

    @Override
    public void increment(TemporalUtility utility) {
        switch (utility) {
            case SHORT_TERM: {
                ++this.shortTermUtilityPageCount;
                break;
            }
            case LONG_TERM: {
                ++this.longTermUtilityPageCount;
            }
        }
    }

    @Override
    public void decrement(TemporalUtility utility) {
        switch (utility) {
            case SHORT_TERM: {
                --this.shortTermUtilityPageCount;
                break;
            }
            case LONG_TERM: {
                --this.longTermUtilityPageCount;
            }
        }
    }
}

