/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.full.SkipAllButCached;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;

enum MultiPassStore {
    NODES{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getNodeStore();
        }

        @Override
        DiffRecordAccess filter(DiffRecordAccess recordAccess, final int iPass, final long recordsPerPass) {
            return new SkipAllButCached(recordAccess){

                @Override
                public RecordReference<NodeRecord> node(long id) {
                    if (MultiPassStore.recordInCurrentPass(id, iPass, recordsPerPass)) {
                        return this.recordAccess.node(id);
                    }
                    return RecordReference.SkippingReference.skipReference();
                }
            };
        }
    }
    ,
    RELATIONSHIPS{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getRelationshipStore();
        }

        @Override
        DiffRecordAccess filter(DiffRecordAccess recordAccess, final int iPass, final long recordsPerPass) {
            return new SkipAllButCached(recordAccess){

                @Override
                public RecordReference<RelationshipRecord> relationship(long id) {
                    if (MultiPassStore.recordInCurrentPass(id, iPass, recordsPerPass)) {
                        return this.recordAccess.relationship(id);
                    }
                    return RecordReference.SkippingReference.skipReference();
                }
            };
        }
    }
    ,
    PROPERTIES{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getPropertyStore();
        }

        @Override
        DiffRecordAccess filter(DiffRecordAccess recordAccess, final int iPass, final long recordsPerPass) {
            return new SkipAllButCached(recordAccess){

                @Override
                public RecordReference<PropertyRecord> property(long id) {
                    if (MultiPassStore.recordInCurrentPass(id, iPass, recordsPerPass)) {
                        return this.recordAccess.property(id);
                    }
                    return RecordReference.SkippingReference.skipReference();
                }
            };
        }
    }
    ,
    STRINGS{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getNodeStore();
        }

        @Override
        DiffRecordAccess filter(DiffRecordAccess recordAccess, final int iPass, final long recordsPerPass) {
            return new SkipAllButCached(recordAccess){

                @Override
                public RecordReference<DynamicRecord> string(long id) {
                    if (MultiPassStore.recordInCurrentPass(id, iPass, recordsPerPass)) {
                        return this.recordAccess.string(id);
                    }
                    return RecordReference.SkippingReference.skipReference();
                }
            };
        }
    }
    ,
    ARRAYS{

        @Override
        RecordStore getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getNodeStore();
        }

        @Override
        DiffRecordAccess filter(DiffRecordAccess recordAccess, final int iPass, final long recordsPerPass) {
            return new SkipAllButCached(recordAccess){

                @Override
                public RecordReference<DynamicRecord> array(long id) {
                    if (MultiPassStore.recordInCurrentPass(id, iPass, recordsPerPass)) {
                        return this.recordAccess.array(id);
                    }
                    return RecordReference.SkippingReference.skipReference();
                }
            };
        }
    };


    private static boolean recordInCurrentPass(long id, int iPass, long recordsPerPass) {
        return id >= (long)iPass * recordsPerPass && id < (long)(iPass + 1) * recordsPerPass;
    }

    public List<DiffRecordAccess> multiPassFilters(long memoryPerPass, StoreAccess storeAccess, DiffRecordAccess recordAccess) {
        ArrayList<DiffRecordAccess> filters = new ArrayList<DiffRecordAccess>();
        RecordStore recordStore = this.getRecordStore(storeAccess);
        long recordsPerPass = memoryPerPass / (long)recordStore.getRecordSize();
        long highId = recordStore.getHighId();
        int iPass = 0;
        while ((long)iPass * recordsPerPass <= highId) {
            filters.add(this.filter(recordAccess, iPass, recordsPerPass));
            ++iPass;
        }
        return filters;
    }

    abstract RecordStore getRecordStore(StoreAccess var1);

    abstract DiffRecordAccess filter(DiffRecordAccess var1, int var2, long var3);

    static class Factory {
        private final CheckDecorator decorator;
        private final DiffRecordAccess recordAccess;
        private final long totalMappedMemory;
        private final StoreAccess storeAccess;
        private final InconsistencyReport report;

        Factory(CheckDecorator decorator, long totalMappedMemory, StoreAccess storeAccess, DiffRecordAccess recordAccess, InconsistencyReport report) {
            this.decorator = decorator;
            this.totalMappedMemory = totalMappedMemory;
            this.storeAccess = storeAccess;
            this.recordAccess = recordAccess;
            this.report = report;
        }

        StoreProcessor[] createAll(MultiPassStore ... stores) {
            ArrayList<StoreProcessor> result = new ArrayList<StoreProcessor>();
            for (MultiPassStore store : stores) {
                List<DiffRecordAccess> filters = store.multiPassFilters(this.totalMappedMemory, this.storeAccess, this.recordAccess);
                for (DiffRecordAccess filter : filters) {
                    result.add(new StoreProcessor(this.decorator, new ConsistencyReporter(filter, this.report)));
                }
            }
            return result.toArray(new StoreProcessor[result.size()]);
        }
    }
}

