/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;

enum RelationshipNodeField implements RecordField<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>,
ComparativeRecordChecker<RelationshipRecord, NodeRecord, ConsistencyReport.RelationshipConsistencyReport>
{
    SOURCE{

        @Override
        public long valueFrom(RelationshipRecord relationship) {
            return relationship.getFirstNode();
        }

        @Override
        public long prev(RelationshipRecord relationship) {
            return relationship.getFirstPrevRel();
        }

        @Override
        public long next(RelationshipRecord relationship) {
            return relationship.getFirstNextRel();
        }

        @Override
        void illegalNode(ConsistencyReport.RelationshipConsistencyReport report) {
            report.illegalSourceNode();
        }

        @Override
        void nodeNotInUse(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.sourceNodeNotInUse(node);
        }

        @Override
        void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.sourceNodeDoesNotReferenceBack(node);
        }

        @Override
        void noChain(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.sourceNodeHasNoRelationships(node);
        }

        @Override
        void notFirstInChain(ConsistencyReport.NodeConsistencyReport report, RelationshipRecord relationship) {
            report.relationshipNotFirstInSourceChain(relationship);
        }

        @Override
        void notUpdated(ConsistencyReport.RelationshipConsistencyReport report) {
            report.sourceNodeNotUpdated();
        }
    }
    ,
    TARGET{

        @Override
        public long valueFrom(RelationshipRecord relationship) {
            return relationship.getSecondNode();
        }

        @Override
        public long prev(RelationshipRecord relationship) {
            return relationship.getSecondPrevRel();
        }

        @Override
        public long next(RelationshipRecord relationship) {
            return relationship.getSecondNextRel();
        }

        @Override
        void illegalNode(ConsistencyReport.RelationshipConsistencyReport report) {
            report.illegalTargetNode();
        }

        @Override
        void nodeNotInUse(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.targetNodeNotInUse(node);
        }

        @Override
        void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.targetNodeDoesNotReferenceBack(node);
        }

        @Override
        void noChain(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.targetNodeHasNoRelationships(node);
        }

        @Override
        void notFirstInChain(ConsistencyReport.NodeConsistencyReport report, RelationshipRecord relationship) {
            report.relationshipNotFirstInTargetChain(relationship);
        }

        @Override
        void notUpdated(ConsistencyReport.RelationshipConsistencyReport report) {
            report.targetNodeNotUpdated();
        }
    };


    @Override
    public abstract long valueFrom(RelationshipRecord var1);

    public static RelationshipNodeField select(RelationshipRecord relationship, NodeRecord node) {
        return RelationshipNodeField.select(relationship, node.getId());
    }

    public static RelationshipNodeField select(RelationshipRecord relationship, long nodeId) {
        if (relationship.getFirstNode() == nodeId) {
            return SOURCE;
        }
        if (relationship.getSecondNode() == nodeId) {
            return TARGET;
        }
        return null;
    }

    public abstract long prev(RelationshipRecord var1);

    public abstract long next(RelationshipRecord var1);

    @Override
    public void checkConsistency(RelationshipRecord relationship, ConsistencyReport.RelationshipConsistencyReport report, RecordAccess records) {
        if (this.valueFrom(relationship) < 0L) {
            this.illegalNode(report);
        } else {
            report.forReference(records.node(this.valueFrom(relationship)), this);
        }
    }

    @Override
    public void checkReference(RelationshipRecord relationship, NodeRecord node, ConsistencyReport.RelationshipConsistencyReport report, RecordAccess records) {
        if (!node.inUse()) {
            this.nodeNotInUse(report, node);
        } else if (Record.NO_PREV_RELATIONSHIP.is(this.prev(relationship))) {
            if (node.getNextRel() != relationship.getId()) {
                this.noBackReference(report, node);
            }
        } else if (Record.NO_NEXT_RELATIONSHIP.is(node.getNextRel())) {
            this.noChain(report, node);
        }
    }

    @Override
    public void checkChange(RelationshipRecord oldRecord, RelationshipRecord newRecord, ConsistencyReport.RelationshipConsistencyReport report, DiffRecordAccess records) {
        if (Record.NO_PREV_RELATIONSHIP.is(this.prev(oldRecord)) && (!newRecord.inUse() || this.valueFrom(oldRecord) != this.valueFrom(newRecord) || this.prev(oldRecord) != this.prev(newRecord)) && records.changedNode(this.valueFrom(oldRecord)) == null) {
            this.notUpdated(report);
        }
    }

    abstract void notUpdated(ConsistencyReport.RelationshipConsistencyReport var1);

    abstract void illegalNode(ConsistencyReport.RelationshipConsistencyReport var1);

    abstract void nodeNotInUse(ConsistencyReport.RelationshipConsistencyReport var1, NodeRecord var2);

    abstract void noBackReference(ConsistencyReport.RelationshipConsistencyReport var1, NodeRecord var2);

    abstract void noChain(ConsistencyReport.RelationshipConsistencyReport var1, NodeRecord var2);

    abstract void notFirstInChain(ConsistencyReport.NodeConsistencyReport var1, RelationshipRecord var2);
}

