/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.windowpool.WindowPoolImplementation;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.util.StringLogger;

public class ConsistencyCheckService {
    private final Date timestamp = new Date();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFullConsistencyCheck(String storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, StringLogger logger) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        Map params = tuningConfiguration.getParams();
        params.put(GraphDatabaseSettings.store_dir.name(), storeDir);
        tuningConfiguration.applyChanges(params);
        StoreFactory factory = new StoreFactory(tuningConfiguration, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), ((WindowPoolImplementation)((Object)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_window_pool_implementation))).windowPoolFactory(tuningConfiguration, logger), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), logger, (TxHook)new DefaultTxHook());
        File reportFile = this.chooseReportPath(tuningConfiguration);
        StringLogger report = StringLogger.lazyLogger((File)reportFile);
        NeoStore neoStore = factory.newNeoStore(new File(storeDir, "neostore"));
        try {
            StoreAccess store = new StoreAccess(neoStore);
            summary = new FullCheck(tuningConfiguration, progressFactory).execute(store, StringLogger.tee((StringLogger)logger, (StringLogger)report));
        }
        finally {
            neoStore.close();
        }
        if (!summary.isConsistent()) {
            logger.logMessage(String.format("See '%s' for a detailed consistency report.", reportFile.getPath()));
        }
    }

    private File chooseReportPath(Config tuningConfiguration) {
        File reportPath = (File)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_report_file);
        File reportFile = reportPath == null ? new File((File)tuningConfiguration.get((Setting)GraphDatabaseSettings.store_dir), this.defaultLogFileName()) : (reportPath.isDirectory() ? new File(reportPath, this.defaultLogFileName()) : reportPath);
        return reportFile;
    }

    String defaultLogFileName() {
        return String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(this.timestamp));
    }
}

