/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.report.ConsistencyLogger;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.util.StringLogger;

public class MessageConsistencyLogger
implements ConsistencyLogger {
    private final StringLogger logger;
    private static final String ERROR = "ERROR:";
    private static final String WARNING = "WARNING:";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String TAB = "\t";

    public MessageConsistencyLogger(StringLogger logger) {
        this.logger = logger;
    }

    @Override
    public void error(RecordType recordType, AbstractBaseRecord record, String message, Object ... args) {
        this.log(MessageConsistencyLogger.record(MessageConsistencyLogger.entry(ERROR, message), record), args);
    }

    @Override
    public void error(RecordType recordType, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, String message, Object ... args) {
        this.log(MessageConsistencyLogger.diff(MessageConsistencyLogger.entry(ERROR, message), oldRecord, newRecord), args);
    }

    @Override
    public void warning(RecordType recordType, AbstractBaseRecord record, String message, Object ... args) {
        this.log(MessageConsistencyLogger.record(MessageConsistencyLogger.entry(WARNING, message), record), args);
    }

    @Override
    public void warning(RecordType recordType, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, String message, Object ... args) {
        this.log(MessageConsistencyLogger.diff(MessageConsistencyLogger.entry(WARNING, message), oldRecord, newRecord), args);
    }

    private static StringBuilder entry(String type, String message) {
        StringBuilder log = new StringBuilder(type);
        for (String line : message.split("\n")) {
            log.append(' ').append(line.trim());
        }
        return log;
    }

    private static StringBuilder record(StringBuilder log, AbstractBaseRecord record) {
        return log.append(LINE_SEPARATOR).append(TAB).append(record);
    }

    private static StringBuilder diff(StringBuilder log, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord) {
        return log.append(LINE_SEPARATOR).append(TAB).append("- ").append(oldRecord).append(LINE_SEPARATOR).append(TAB).append("+ ").append(newRecord);
    }

    private void log(StringBuilder log, Object[] args) {
        if (args != null && args.length > 0) {
            log.append(LINE_SEPARATOR).append(TAB).append("Inconsistent with:");
            for (Object arg : args) {
                log.append(' ').append(arg);
            }
        }
        this.logger.logMessage(log.toString());
    }
}

