/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.StoreProcessorTask;
import org.neo4j.helpers.progress.Completion;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;

public enum TaskExecutionOrder {
    MULTI_THREADED{

        @Override
        void execute(RecordStore.Processor processor, List<StoreProcessorTask> tasks, Completion completion) throws ConsistencyCheckIncompleteException {
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            for (StoreProcessorTask task : tasks) {
                executor.submit(new StoreProcessorTask.TaskRunner(processor, task));
            }
            try {
                completion.await(7L, TimeUnit.DAYS);
            }
            catch (Exception e) {
                processor.stopScanning();
                throw new ConsistencyCheckIncompleteException(e);
            }
            finally {
                executor.shutdown();
                try {
                    executor.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {}
            }
        }
    }
    ,
    SINGLE_THREADED{

        @Override
        void execute(RecordStore.Processor processor, List<StoreProcessorTask> tasks, Completion completion) throws ConsistencyCheckIncompleteException {
            try {
                for (StoreProcessorTask task : tasks) {
                    task.singlePass(processor);
                }
            }
            catch (Exception e) {
                throw new ConsistencyCheckIncompleteException(e);
            }
        }
    }
    ,
    MULTI_PASS{

        @Override
        void execute(RecordStore.Processor processor, List<StoreProcessorTask> tasks, Completion completion) throws ConsistencyCheckIncompleteException {
            try {
                for (StoreProcessorTask task : tasks) {
                    task.multiPass();
                }
            }
            catch (Exception e) {
                throw new ConsistencyCheckIncompleteException(e);
            }
        }
    };


    abstract void execute(RecordStore.Processor var1, List<StoreProcessorTask> var2, Completion var3) throws ConsistencyCheckIncompleteException;
}

