/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;

class StoreProcessorTask<R extends AbstractBaseRecord> {
    private final RecordStore<R> store;
    private final StoreProcessor[] processors;
    private final ProgressListener progressListener;

    StoreProcessorTask(RecordStore<R> store, ProgressMonitorFactory.MultiPartBuilder builder, StoreProcessor ... processors) {
        this.store = store;
        this.processors = processors;
        String name = store.getStorageFileName();
        this.progressListener = builder.progressForPart(name.substring(name.lastIndexOf(47) + 1), store.getHighId());
    }

    public void multiPass() {
        for (StoreProcessor processor : this.processors) {
            this.singlePass(processor);
        }
    }

    public void singlePass(RecordStore.Processor processor) {
        try {
            processor.applyFiltered(this.store, this.progressListener, new Predicate[0]);
        }
        catch (Throwable e) {
            this.progressListener.failed(e);
        }
    }

    static class TaskRunner
    implements Runnable {
        private final RecordStore.Processor processor;
        private final StoreProcessorTask task;

        public TaskRunner(RecordStore.Processor processor, StoreProcessorTask task) {
            this.processor = processor;
            this.task = task;
        }

        @Override
        public void run() {
            this.task.singlePass(this.processor);
        }
    }
}

