/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.store.windowpool.WindowPoolImplementation;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.util.StringLogger;

public class ConsistencyCheckService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFullConsistencyCheck(String storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, StringLogger logger) throws ConsistencyCheckIncompleteException {
        StoreFactory factory = new StoreFactory(tuningConfiguration, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), ((WindowPoolImplementation)((Object)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_window_pool_implementation))).windowPoolFactory(tuningConfiguration, logger), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), logger, (TxHook)new DefaultTxHook());
        NeoStore neoStore = factory.newNeoStore(new File(storeDir, "neostore").getAbsolutePath());
        try {
            StoreAccess store = new StoreAccess(neoStore);
            new FullCheck(tuningConfiguration, progressFactory).execute(store, logger);
        }
        finally {
            neoStore.close();
        }
    }
}

